/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.apispec;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.apispec.MethodSchema;
import org.ballerinalang.langserver.apispec.ParameterSchema;
import org.ballerinalang.langserver.apispec.TypeSchema;
import org.eclipse.lsp4j.jsonrpc.json.JsonRpcMethod;

public class ApiSpecGenerator {
    public static JsonObject generate(JsonRpcMethod method) {
        MethodSchema methodSchema = new MethodSchema(method.getMethodName(), ApiSpecGenerator.convertParameters(method.getParameterTypes()), method.getReturnType() != null ? ApiSpecGenerator.convertType(method.getReturnType()) : null);
        return new Gson().toJsonTree((Object)methodSchema).getAsJsonObject();
    }

    private static List<ParameterSchema> convertParameters(Type[] parameterTypes) {
        if (parameterTypes == null) {
            return List.of();
        }
        ArrayList<ParameterSchema> parameters = new ArrayList<ParameterSchema>();
        for (int i = 0; i < parameterTypes.length; ++i) {
            parameters.add(new ParameterSchema("param" + i, ApiSpecGenerator.convertType(parameterTypes[i])));
        }
        return parameters;
    }

    private static TypeSchema convertType(Type type) {
        if (type == null) {
            throw new IllegalArgumentException("Type cannot be null");
        }
        return ApiSpecGenerator.processType(type, new HashSet<Type>());
    }

    private static TypeSchema processType(Type type, Set<Type> processedTypes) {
        if (processedTypes.contains(type)) {
            return TypeSchema.object(null, type.getTypeName());
        }
        HashSet<Type> newProcessedTypes = new HashSet<Type>(processedTypes);
        newProcessedTypes.add(type);
        if (type instanceof Class) {
            return ApiSpecGenerator.handleClass((Class)type, newProcessedTypes);
        }
        if (type instanceof ParameterizedType) {
            return ApiSpecGenerator.handleParameterizedType((ParameterizedType)type, newProcessedTypes);
        }
        if (type instanceof TypeVariable) {
            return ApiSpecGenerator.handleTypeVariable((TypeVariable)type);
        }
        if (type instanceof WildcardType) {
            return ApiSpecGenerator.handleWildcardType((WildcardType)type, newProcessedTypes);
        }
        return TypeSchema.object(null, type.getTypeName());
    }

    private static TypeSchema handleClass(Class<?> clazz, Set<Type> processedTypes) {
        if (clazz.isPrimitive()) {
            return ApiSpecGenerator.handlePrimitive(clazz);
        }
        if (clazz.isEnum()) {
            return ApiSpecGenerator.handleEnum(clazz);
        }
        if (clazz.isArray()) {
            return TypeSchema.array(ApiSpecGenerator.processType(clazz.getComponentType(), processedTypes), clazz.getTypeName());
        }
        if (Collection.class.isAssignableFrom(clazz)) {
            return TypeSchema.array(TypeSchema.object(null, "java.lang.Object"), clazz.getTypeName());
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return TypeSchema.map(TypeSchema.object(null, "java.lang.Object"), clazz.getTypeName());
        }
        if (clazz.equals(String.class)) {
            return TypeSchema.string(clazz.getName());
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return TypeSchema.number(clazz.getTypeName());
        }
        if (Boolean.class.equals(clazz)) {
            return TypeSchema.bool(clazz.getTypeName());
        }
        return ApiSpecGenerator.handleObject(clazz, processedTypes);
    }

    private static TypeSchema handlePrimitive(Class<?> clazz) {
        if (clazz == Integer.TYPE || clazz == Long.TYPE || clazz == Short.TYPE || clazz == Byte.TYPE) {
            return TypeSchema.integer(clazz.getName());
        }
        if (clazz == Double.TYPE || clazz == Float.TYPE) {
            return TypeSchema.number(clazz.getName());
        }
        if (clazz == Boolean.TYPE) {
            return TypeSchema.bool(clazz.getName());
        }
        if (clazz == Character.TYPE) {
            return TypeSchema.string(clazz.getName());
        }
        throw new IllegalArgumentException("Unsupported primitive type: " + String.valueOf(clazz));
    }

    private static TypeSchema handleEnum(Class<?> clazz) {
        return TypeSchema.enumSchema(Arrays.stream(clazz.getEnumConstants()).map(Object::toString).collect(Collectors.toList()), clazz.getTypeName());
    }

    private static TypeSchema handleObject(Class<?> clazz, Set<Type> processedTypes) {
        HashMap<String, TypeSchema> properties = new HashMap<String, TypeSchema>();
        for (Field field : clazz.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isTransient(field.getModifiers())) continue;
            properties.put(field.getName(), ApiSpecGenerator.processType(field.getGenericType(), processedTypes));
        }
        return TypeSchema.object(properties, clazz.getTypeName());
    }

    private static TypeSchema handleParameterizedType(ParameterizedType type, Set<Type> processedTypes) {
        Type rawType = type.getRawType();
        if (rawType instanceof Class) {
            Class rawClass = (Class)rawType;
            if (Collection.class.isAssignableFrom(rawClass)) {
                return TypeSchema.array(ApiSpecGenerator.processType(type.getActualTypeArguments()[0], processedTypes), type.getTypeName());
            }
            if (Map.class.isAssignableFrom(rawClass)) {
                return TypeSchema.map(ApiSpecGenerator.processType(type.getActualTypeArguments()[1], processedTypes), type.getTypeName());
            }
            return ApiSpecGenerator.handleClass(rawClass, processedTypes);
        }
        return TypeSchema.object(null, type.getTypeName());
    }

    private static TypeSchema handleTypeVariable(TypeVariable<?> type) {
        Type[] bounds = type.getBounds();
        return TypeSchema.object(null, bounds.length > 0 ? bounds[0].getTypeName() : "java.lang.Object");
    }

    private static TypeSchema handleWildcardType(WildcardType type, Set<Type> processedTypes) {
        Type[] upperBounds = type.getUpperBounds();
        if (upperBounds.length > 0) {
            return ApiSpecGenerator.processType(upperBounds[0], processedTypes);
        }
        return TypeSchema.object(null, "java.lang.Object");
    }
}

