/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class CodeActionModuleId
implements ModuleID {
    private static final String ORG_SEPARATOR = "/";
    private final String orgName;
    private final String moduleName;
    private final String version;
    private final String alias;

    private CodeActionModuleId(String orgName, String moduleName, String alias, String version) {
        this.orgName = orgName;
        this.moduleName = moduleName;
        this.alias = alias;
        this.version = version;
    }

    public static CodeActionModuleId from(String orgName, String moduleName, String version) {
        List<String> names = Arrays.stream(moduleName.split("\\.")).toList();
        String alias = moduleName.equals(".") ? moduleName : names.get(names.size() - 1);
        return new CodeActionModuleId(orgName, moduleName, alias, version);
    }

    public static CodeActionModuleId from(String orgName, String moduleName, String alias, String version) {
        return new CodeActionModuleId(orgName, moduleName, alias, version);
    }

    public static CodeActionModuleId from(ImportDeclarationNode importPkg) {
        String orgName = importPkg.orgName().isPresent() ? String.valueOf(((ImportOrgNameNode)importPkg.orgName().get()).orgName()) + ORG_SEPARATOR : "";
        StringBuilder pkgNameBuilder = new StringBuilder();
        String pkgName = importPkg.moduleName().stream().map(Token::text).collect(Collectors.joining("."));
        pkgName = pkgNameBuilder.append(pkgName).toString();
        String alias = importPkg.prefix().isEmpty() ? "" : ((ImportPrefixNode)importPkg.prefix().get()).prefix().text();
        return new CodeActionModuleId(orgName, pkgName, alias, "");
    }

    public String orgName() {
        return this.orgName;
    }

    public String packageName() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public String moduleName() {
        return this.moduleName;
    }

    public String version() {
        return this.version;
    }

    public String modulePrefix() {
        return this.alias;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CodeActionModuleId that = (CodeActionModuleId)o;
        return this.orgName.equals(that.orgName) && this.moduleName.equals(that.moduleName) && this.version.equals(that.version);
    }

    public int hashCode() {
        return Objects.hash(this.orgName, this.moduleName, this.version);
    }
}

