/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction;

import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.BinaryExpressionNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ExpressionFunctionBodyNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.KeySpecifierNode;
import io.ballerina.compiler.syntax.tree.LetExpressionNode;
import io.ballerina.compiler.syntax.tree.LetVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MapTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.RestArgumentNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SpreadFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TableConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.TableTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TemplateExpressionNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeParameterNode;
import io.ballerina.compiler.syntax.tree.TypeTestExpressionNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class CodeActionNodeValidator
extends NodeTransformer<Boolean> {
    private final Set<Node> visitedNodes = new HashSet<Node>();

    protected Boolean transformSyntaxNode(Node node) {
        return node.parent() == null || (Boolean)node.parent().apply((NodeTransformer)this) != false;
    }

    private Boolean isVisited(Node node) {
        if (this.visitedNodes.contains(node)) {
            return true;
        }
        this.visitedNodes.add(node);
        return false;
    }

    public Boolean transform(VariableDeclarationNode node) {
        return this.isVisited((Node)node) != false || (Boolean)node.typedBindingPattern().apply((NodeTransformer)this) != false && (node.equalsToken().isEmpty() || !((Token)node.equalsToken().get()).isMissing() && node.initializer().isPresent() && (Boolean)((ExpressionNode)node.initializer().get()).apply((NodeTransformer)this) != false);
    }

    public Boolean transform(FunctionCallExpressionNode node) {
        if (this.isVisited((Node)node).booleanValue()) {
            return true;
        }
        for (int i = 0; i < node.arguments().separatorSize(); ++i) {
            if (!node.arguments().getSeparator(i).isMissing()) continue;
            return false;
        }
        return !node.functionName().isMissing() && !node.openParenToken().isMissing() && !node.closeParenToken().isMissing() && node.arguments().stream().allMatch(arg -> (Boolean)arg.apply((NodeTransformer)this)) && (Boolean)node.parent().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(TypedBindingPatternNode node) {
        return this.isVisited((Node)node) != false || (Boolean)node.bindingPattern().apply((NodeTransformer)this) != false && (Boolean)node.typeDescriptor().apply((NodeTransformer)this) != false && (Boolean)node.parent().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(CaptureBindingPatternNode node) {
        return this.isVisited((Node)node) != false || !node.variableName().isMissing() && (Boolean)node.parent().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(CheckExpressionNode node) {
        return this.isVisited((Node)node) != false || !node.checkKeyword().isMissing() && (Boolean)node.expression().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(TableTypeDescriptorNode node) {
        return this.isVisited((Node)node) != false || !node.tableKeywordToken().isMissing() && (Boolean)node.rowTypeParameterNode().apply((NodeTransformer)this) != false && (node.keyConstraintNode().isEmpty() || (Boolean)((Node)node.keyConstraintNode().get()).apply((NodeTransformer)this) != false);
    }

    public Boolean transform(TypeParameterNode node) {
        return this.isVisited((Node)node) != false || !node.ltToken().isMissing() && !node.gtToken().isMissing() && (Boolean)node.typeNode().apply((NodeTransformer)this) != false && (Boolean)node.parent().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(KeySpecifierNode node) {
        return this.isVisited((Node)node) != false || !node.keyKeyword().isMissing() && !node.openParenToken().isMissing() && !node.closeParenToken().isMissing() && node.fieldNames().stream().noneMatch(Node::isMissing);
    }

    public Boolean transform(SimpleNameReferenceNode node) {
        return this.isVisited((Node)node) != false || !node.name().isMissing() && (Boolean)node.parent().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(AssignmentStatementNode node) {
        return this.isVisited((Node)node) != false || !node.equalsToken().isMissing() && (Boolean)node.expression().apply((NodeTransformer)this) != false && (Boolean)node.varRef().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(BinaryExpressionNode node) {
        return this.isVisited((Node)node) != false || !node.operator().isMissing() && (Boolean)node.lhsExpr().apply((NodeTransformer)this) != false && (Boolean)node.rhsExpr().apply((NodeTransformer)this) != false && (Boolean)node.parent().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(LetExpressionNode node) {
        return this.isVisited((Node)node) != false || !node.letKeyword().isMissing() && !node.inKeyword().isMissing() && node.letVarDeclarations().stream().allMatch(arg -> (Boolean)arg.apply((NodeTransformer)this)) && (Boolean)node.expression().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(LetVariableDeclarationNode node) {
        return this.isVisited((Node)node) != false || !node.equalsToken().isMissing() && (Boolean)node.typedBindingPattern().apply((NodeTransformer)this) != false && (Boolean)node.expression().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(SpreadFieldNode node) {
        return this.isVisited((Node)node) != false || !node.ellipsis().isMissing() && (Boolean)node.valueExpr().apply((NodeTransformer)this) != false && (Boolean)node.parent().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(MappingConstructorExpressionNode node) {
        return this.isVisited((Node)node) != false || !node.openBrace().isMissing() && !node.closeBrace().isMissing() && node.fields().stream().allMatch(arg -> (Boolean)arg.apply((NodeTransformer)this)) && (Boolean)node.parent().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(FieldAccessExpressionNode node) {
        return this.isVisited((Node)node) != false || (Boolean)node.expression().apply((NodeTransformer)this) != false && !node.dotToken().isMissing() && (Boolean)node.fieldName().apply((NodeTransformer)this) != false && (Boolean)node.parent().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(PositionalArgumentNode node) {
        return this.isVisited((Node)node) != false || (Boolean)node.expression().apply((NodeTransformer)this) != false && (Boolean)node.parent().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(BasicLiteralNode node) {
        return this.isVisited((Node)node) != false || !node.literalToken().isMissing() && (Boolean)node.parent().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(NamedArgumentNode node) {
        return this.isVisited((Node)node) != false || !node.equalsToken().isMissing() && (Boolean)node.argumentName().apply((NodeTransformer)this) != false && (Boolean)node.expression().apply((NodeTransformer)this) != false && (Boolean)node.parent().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(RestArgumentNode node) {
        return this.isVisited((Node)node) != false || !node.ellipsis().isMissing() && (Boolean)node.expression().apply((NodeTransformer)this) != false && (Boolean)node.parent().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(ListConstructorExpressionNode node) {
        return this.isVisited((Node)node) != false || !node.openBracket().isMissing() && !node.closeBracket().isMissing() && node.expressions().stream().allMatch(arg -> (Boolean)arg.apply((NodeTransformer)this)) && (Boolean)node.parent().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(SpecificFieldNode node) {
        return this.isVisited((Node)node) != false || node.colon().isPresent() && !node.fieldName().toSourceCode().isEmpty() && (node.valueExpr().isEmpty() || (Boolean)((ExpressionNode)node.valueExpr().get()).apply((NodeTransformer)this) != false) && (Boolean)node.parent().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(RequiredParameterNode node) {
        if (node.paramName().isEmpty()) {
            return false;
        }
        Token paramName = (Token)node.paramName().get();
        return this.isVisited((Node)node) != false || (Boolean)node.typeName().apply((NodeTransformer)this) != false && paramName.leadingInvalidTokens().isEmpty() && paramName.trailingInvalidTokens().isEmpty();
    }

    public Boolean transform(MapTypeDescriptorNode node) {
        return this.isVisited((Node)node) != false || !node.mapKeywordToken().isMissing() && !node.mapTypeParamsNode().isMissing() && !node.mapTypeParamsNode().gtToken().isMissing() && !node.mapTypeParamsNode().ltToken().isMissing();
    }

    public Boolean transform(TypeTestExpressionNode node) {
        return this.isVisited((Node)node) != false || !node.isKeyword().isMissing() && (Boolean)node.typeDescriptor().apply((NodeTransformer)this) != false && (Boolean)node.expression().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(FunctionDefinitionNode node) {
        return this.isVisited((Node)node) != false || !node.functionKeyword().isMissing() && !node.functionName().isMissing() && node.leadingInvalidTokens().isEmpty() && node.trailingInvalidTokens().isEmpty() && (Boolean)node.functionSignature().apply((NodeTransformer)this) != false && (Boolean)node.functionBody().apply((NodeTransformer)this) != false && (Boolean)node.parent().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(FunctionSignatureNode node) {
        return this.isVisited((Node)node) != false || !node.openParenToken().isMissing() && !node.closeParenToken().isMissing() && node.leadingInvalidTokens().isEmpty() && node.trailingInvalidTokens().isEmpty() && (node.returnTypeDesc().isEmpty() || (Boolean)((ReturnTypeDescriptorNode)node.returnTypeDesc().get()).apply((NodeTransformer)this) != false) && node.parameters().stream().allMatch(parameterNode -> (Boolean)parameterNode.apply((NodeTransformer)this));
    }

    public Boolean transform(FunctionBodyBlockNode node) {
        return this.isVisited((Node)node) != false || !node.isMissing() && !node.openBraceToken().isMissing() && !node.closeBraceToken().isMissing() && node.leadingInvalidTokens().isEmpty() && node.trailingInvalidTokens().isEmpty() && (Boolean)node.parent().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(ReturnTypeDescriptorNode node) {
        return this.isVisited((Node)node) != false || !node.returnsKeyword().isMissing() && (Boolean)node.type().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(ExpressionFunctionBodyNode node) {
        return this.isVisited((Node)node) != false || !node.rightDoubleArrow().isMissing() && !node.expression().isMissing();
    }

    public Boolean transform(ClassDefinitionNode node) {
        return this.isVisited((Node)node) != false || !node.classKeyword().isMissing() && !node.className().isMissing() && !node.openBrace().isMissing() && !node.closeBrace().isMissing() && node.leadingInvalidTokens().isEmpty() && node.trailingInvalidTokens().isEmpty() && node.members().stream().allMatch(member -> (Boolean)member.apply((NodeTransformer)this));
    }

    public Boolean transform(TableConstructorExpressionNode node) {
        return this.isVisited((Node)node) != false || !node.tableKeyword().isMissing() && !node.openBracket().isMissing() && !node.closeBracket().isMissing() && (node.keySpecifier().isEmpty() || (Boolean)((KeySpecifierNode)node.keySpecifier().get()).apply((NodeTransformer)this) != false) && node.rows().stream().allMatch(row -> (Boolean)row.apply((NodeTransformer)this)) && (Boolean)node.parent().apply((NodeTransformer)this) != false;
    }

    public Boolean transform(TemplateExpressionNode node) {
        return this.isVisited((Node)node) != false || !node.startBacktick().isMissing() && !node.endBacktick().isMissing();
    }

    public Boolean transform(QualifiedNameReferenceNode node) {
        return this.isVisited((Node)node) != false || !node.colon().isMissing() && !node.modulePrefix().isMissing() && node.parent() != null && (node.parent().kind() == SyntaxKind.TYPED_BINDING_PATTERN || (Boolean)node.parent().apply((NodeTransformer)this) != false);
    }

    public static boolean validate(Node node) {
        Node validatorNode = node;
        if (node.kind().equals((Object)SyntaxKind.LIST)) {
            validatorNode = node.parent();
        }
        CodeActionNodeValidator nodeValidator = new CodeActionNodeValidator();
        return Optional.ofNullable((Boolean)validatorNode.apply((NodeTransformer)nodeValidator)).orElse(true);
    }
}

