/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CancellationException;
import org.ballerinalang.langserver.LSClientLogger;
import org.ballerinalang.langserver.LSContextOperation;
import org.ballerinalang.langserver.codeaction.CodeActionNodeAnalyzer;
import org.ballerinalang.langserver.codeaction.CodeActionProvidersHolder;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.codeaction.RangeBasedPositionDetailsImpl;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.CodeActionResolveContext;
import org.ballerinalang.langserver.commons.codeaction.ResolvableCodeAction;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.LSCodeActionProvider;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.ResolvableCodeActionProvider;
import org.ballerinalang.langserver.telemetry.TelemetryUtil;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public final class CodeActionRouter {
    private CodeActionRouter() {
    }

    public static List<CodeAction> getAvailableCodeActions(CodeActionContext ctx) {
        LSClientLogger clientLogger = LSClientLogger.getInstance(ctx.languageServercontext());
        ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
        CodeActionProvidersHolder codeActionProvidersHolder = CodeActionProvidersHolder.getInstance(ctx.languageServercontext());
        Optional syntaxTree = ctx.currentSyntaxTree();
        if (syntaxTree.isEmpty()) {
            clientLogger.logTrace(LSContextOperation.TXT_CODE_ACTION.getName() + "  Syntax tree is empty for file " + ctx.fileUri());
            return Collections.emptyList();
        }
        if (ctx.currentSemanticModel().isEmpty()) {
            clientLogger.logTrace(LSContextOperation.TXT_CODE_ACTION.getName() + "  Semantic model is empty for module " + ctx.currentModule().map(module -> module.moduleName().toString()).orElse(""));
            return Collections.emptyList();
        }
        Range highlightedRange = ctx.range();
        CodeActionNodeAnalyzer analyzer = CodeActionNodeAnalyzer.analyze(highlightedRange, (SyntaxTree)syntaxTree.get());
        Optional<NonTerminalNode> codeActionNode = analyzer.getCodeActionNode();
        SyntaxKind syntaxKind = analyzer.getSyntaxKind();
        if (codeActionNode.isPresent() && syntaxKind != SyntaxKind.NONE) {
            Range range = PositionUtil.toRange(codeActionNode.get().lineRange());
            Node expressionNode = CodeActionUtil.largestExpressionNode((Node)codeActionNode.get(), range);
            TypeSymbol matchedTypeSymbol = CodeActionRouter.getMatchedTypeSymbol(ctx, expressionNode).orElse(null);
            RangeBasedPositionDetails posDetails = RangeBasedPositionDetailsImpl.PositionDetailsBuilder.newBuilder().setTopLevelNodeType(matchedTypeSymbol).setTopLevelNode(codeActionNode.get()).setCodeActionNode(codeActionNode.get()).setDocumentableNode(analyzer.getDocumentableNode().orElse(null)).setEnclosingDocumentableNode(analyzer.getEnclosingDocumentableNode().orElse(null)).setStatementNode(analyzer.getStatementNode().orElse(null)).build();
            codeActionProvidersHolder.getActiveRangeBasedProviders(syntaxKind, ctx).forEach(provider -> {
                try {
                    ctx.checkCancelled();
                    if (!provider.validate(ctx, posDetails)) {
                        return;
                    }
                    List codeActionsOut = provider.getCodeActions(ctx, posDetails);
                    if (codeActionsOut != null) {
                        codeActionsOut.forEach(codeAction -> TelemetryUtil.addReportFeatureUsageCommandToCodeAction(codeAction, (LSCodeActionProvider)provider));
                        codeActions.addAll(codeActionsOut);
                    }
                }
                catch (CancellationException codeActionsOut) {
                }
                catch (Exception e) {
                    String msg = "CodeAction '" + provider.getClass().getSimpleName() + "' failed!";
                    clientLogger.logError(LSContextOperation.TXT_CODE_ACTION, msg, e, null, new Position[]{null});
                }
            });
        }
        ctx.diagnostics(ctx.filePath()).stream().filter(diag -> PositionUtil.isRangeWithinRange(highlightedRange, PositionUtil.toRange(diag.location().lineRange()))).forEach(diagnostic -> {
            DiagBasedPositionDetails positionDetails = CodeActionUtil.computePositionDetails((SyntaxTree)syntaxTree.get(), diagnostic, ctx);
            codeActionProvidersHolder.getActiveDiagnosticsBasedProviders(ctx).forEach(provider -> {
                try {
                    ctx.checkCancelled();
                    if (!provider.validate(diagnostic, positionDetails, ctx)) {
                        return;
                    }
                    List codeActionsOut = provider.getCodeActions(diagnostic, positionDetails, ctx);
                    codeActionsOut.forEach(codeAction -> TelemetryUtil.addReportFeatureUsageCommandToCodeAction(codeAction, (LSCodeActionProvider)provider));
                    codeActions.addAll(codeActionsOut);
                }
                catch (CancellationException codeActionsOut) {
                }
                catch (Exception e) {
                    String msg = "CodeAction '" + provider.getClass().getSimpleName() + "' failed!";
                    clientLogger.logError(LSContextOperation.TXT_CODE_ACTION, msg, e, null, new Position[]{null});
                }
            });
        });
        return codeActions;
    }

    public static CodeAction resolveCodeAction(ResolvableCodeAction codeAction, CodeActionResolveContext resolveContext) {
        CodeActionProvidersHolder codeActionProvidersHolder = CodeActionProvidersHolder.getInstance(resolveContext.languageServercontext());
        Optional<? extends LSCodeActionProvider> provider = codeActionProvidersHolder.getProviderByName(codeAction.getData().getCodeActionName());
        ResolvableCodeAction action = codeAction;
        if (provider.isPresent() && provider.get() instanceof ResolvableCodeActionProvider) {
            action = ((ResolvableCodeActionProvider)provider.get()).resolve(codeAction, resolveContext);
        }
        return action;
    }

    private static Optional<TypeSymbol> getMatchedTypeSymbol(CodeActionContext context, Node node) {
        SemanticModel semanticModel = (SemanticModel)context.currentSemanticModel().orElseThrow();
        if (node.kind() != SyntaxKind.CAPTURE_BINDING_PATTERN) {
            return semanticModel.typeOf(node.lineRange());
        }
        List visibleSymbols = context.visibleSymbols(context.cursorPosition());
        CaptureBindingPatternNode patternNode = (CaptureBindingPatternNode)node;
        String varName = patternNode.variableName().text();
        return visibleSymbols.stream().filter(symbol -> symbol.getName().orElse("").equals(varName)).map(SymbolUtil::getTypeDescriptor).findFirst().orElse(Optional.empty());
    }
}

