/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.CompoundAssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.IfElseStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.eclipse.lsp4j.Range;

public class ExtractToFunctionStatementAnalyzer
extends NodeVisitor {
    private final List<Symbol> updatedSymbols = new ArrayList<Symbol>();
    private final List<Symbol> declaredVariableSymbols = new ArrayList<Symbol>();
    private final List<Node> selectedNodes = new ArrayList<Node>();
    private boolean isExtractable = true;
    private final Range selectedRange;
    private final SemanticModel semanticModel;
    private final Set<SyntaxKind> notSupportedSyntaxKindsWithinRange = Set.of(SyntaxKind.BREAK_STATEMENT, SyntaxKind.CONTINUE_STATEMENT, SyntaxKind.PANIC_STATEMENT, SyntaxKind.NAMED_WORKER_DECLARATION, SyntaxKind.FORK_STATEMENT, SyntaxKind.TRANSACTION_STATEMENT, SyntaxKind.ROLLBACK_STATEMENT, SyntaxKind.RETRY_STATEMENT, SyntaxKind.XML_NAMESPACE_DECLARATION, SyntaxKind.REMOTE_METHOD_CALL_ACTION, SyntaxKind.BRACED_ACTION, SyntaxKind.CHECK_ACTION, SyntaxKind.START_ACTION, SyntaxKind.TRAP_ACTION, SyntaxKind.FLUSH_ACTION, SyntaxKind.ASYNC_SEND_ACTION, SyntaxKind.SYNC_SEND_ACTION, SyntaxKind.RECEIVE_ACTION, SyntaxKind.WAIT_ACTION, SyntaxKind.QUERY_ACTION, SyntaxKind.COMMIT_ACTION, SyntaxKind.CLIENT_RESOURCE_ACCESS_ACTION, SyntaxKind.RETURN_STATEMENT);

    public ExtractToFunctionStatementAnalyzer(Range selectedRange, SemanticModel semanticModel) {
        this.selectedRange = selectedRange;
        this.semanticModel = semanticModel;
    }

    public void analyze(NonTerminalNode node) {
        if (node.kind() == SyntaxKind.LIST) {
            node.children().forEach(child -> {
                if (PositionUtil.isRangeWithinRange(PositionUtil.toRange(child.lineRange()), this.selectedRange)) {
                    this.selectedNodes.add((Node)child);
                    child.accept((NodeVisitor)this);
                }
            });
        } else {
            if (!PositionUtil.isRangeWithinRange(PositionUtil.toRange(node.lineRange()), this.selectedRange)) {
                this.isExtractable = false;
                return;
            }
            this.selectedNodes.add((Node)node);
            node.accept((NodeVisitor)this);
        }
        if (this.selectedNodes.isEmpty()) {
            this.isExtractable = false;
        }
    }

    public List<Symbol> getUpdatedSymbols() {
        return this.updatedSymbols;
    }

    public List<Symbol> getDeclaredVariableSymbols() {
        return this.declaredVariableSymbols;
    }

    public List<Node> getSelectedNodes() {
        return this.selectedNodes;
    }

    public boolean isExtractable() {
        return this.isExtractable;
    }

    public void visit(IfElseStatementNode node) {
        if (node.parent().kind() == SyntaxKind.ELSE_BLOCK) {
            this.isExtractable = false;
        }
        super.visit(node);
    }

    public void visit(AssignmentStatementNode node) {
        Optional symbol = this.semanticModel.symbol(node.varRef());
        if (symbol.isPresent() && !this.updatedSymbols.contains(symbol.get())) {
            this.updatedSymbols.add((Symbol)symbol.get());
        }
    }

    public void visit(CompoundAssignmentStatementNode node) {
        Optional symbol = this.semanticModel.symbol((Node)node.lhsExpression());
        if (symbol.isPresent() && !this.updatedSymbols.contains(symbol.get())) {
            this.updatedSymbols.add((Symbol)symbol.get());
        }
    }

    public void visit(VariableDeclarationNode node) {
        Optional symbol = this.semanticModel.symbol((Node)node.typedBindingPattern().bindingPattern());
        symbol.ifPresent(this.declaredVariableSymbols::add);
        super.visit(node);
    }

    protected void visitSyntaxNode(Node node) {
        if (this.notSupportedSyntaxKindsWithinRange.contains(node.kind())) {
            this.isExtractable = false;
            return;
        }
        NonTerminalNode nonTerminalNode = (NonTerminalNode)node;
        for (Node child : nonTerminalNode.children()) {
            child.accept((NodeVisitor)this);
        }
    }
}

