/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction;

import io.ballerina.compiler.syntax.tree.DoStatementNode;
import io.ballerina.compiler.syntax.tree.ForEachStatementNode;
import io.ballerina.compiler.syntax.tree.LockStatementNode;
import io.ballerina.compiler.syntax.tree.MatchStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.WhileStatementNode;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.LineRange;
import java.util.Optional;

public class FailStatementResolver
extends NodeTransformer<Optional<Node>> {
    private final Diagnostic diagnostic;

    public FailStatementResolver(Diagnostic diagnostic) {
        this.diagnostic = diagnostic;
    }

    public Optional<Node> getRegularCompoundStatementNode(Node node) {
        return (Optional)node.apply((NodeTransformer)this);
    }

    public Optional<Node> transform(WhileStatementNode whileStatementNode) {
        LineRange diagnosticLineRange = this.diagnostic.location().lineRange();
        LineRange whileStmtConLineRange = whileStatementNode.condition().lineRange();
        if (diagnosticLineRange.startLine().line() == whileStmtConLineRange.startLine().line() && diagnosticLineRange.startLine().offset() > whileStmtConLineRange.startLine().offset() && diagnosticLineRange.endLine().offset() < whileStmtConLineRange.endLine().offset()) {
            return Optional.of(whileStatementNode.whileKeyword());
        }
        return Optional.of(whileStatementNode);
    }

    public Optional<Node> transform(DoStatementNode doStatementNode) {
        return Optional.of(doStatementNode);
    }

    public Optional<Node> transform(MatchStatementNode matchStatementNode) {
        return Optional.of(matchStatementNode);
    }

    public Optional<Node> transform(ForEachStatementNode forEachStatementNode) {
        return Optional.of(forEachStatementNode);
    }

    public Optional<Node> transform(LockStatementNode lockStatementNode) {
        return Optional.of(lockStatementNode);
    }

    protected Optional<Node> transformSyntaxNode(Node node) {
        if (node.parent() != null) {
            return (Optional)node.parent().apply((NodeTransformer)this);
        }
        return Optional.empty();
    }
}

