/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction;

import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionStatementNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RemoteMethodCallActionNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.tools.text.LinePosition;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class ScopedSymbolFinder
extends NodeVisitor {
    private final Range range;
    private LinePosition currentIdentifierPos;
    private NonTerminalNode currentNode;
    private static final Map<Class<?>, Method> SCOPED_NODE_TO_VISIT_METHOD = Arrays.stream(ScopedSymbolFinder.class.getDeclaredMethods()).filter(s -> "visit".equals(s.getName()) && s.getParameterTypes().length > 0).collect(Collectors.toMap(k -> k.getParameterTypes()[0], v -> v));

    public ScopedSymbolFinder(Range range) {
        Position end = new Position(range.getEnd().getLine(), range.getEnd().getCharacter() - 1);
        this.range = new Range(range.getStart(), end);
    }

    public Optional<NonTerminalNode> node() {
        return Optional.ofNullable(this.currentNode);
    }

    public Optional<LinePosition> nodeIdentifierPos() {
        return Optional.ofNullable(this.currentIdentifierPos);
    }

    public void visit(FunctionCallExpressionNode functionCallExpressionNode) {
        this.currentNode = functionCallExpressionNode;
        this.currentIdentifierPos = this.nameRefPosition(functionCallExpressionNode.functionName());
    }

    public void visit(MethodCallExpressionNode methodCallExpressionNode) {
        this.currentNode = methodCallExpressionNode;
        this.currentIdentifierPos = this.nameRefPosition(methodCallExpressionNode.methodName());
    }

    public void visit(RemoteMethodCallActionNode remoteMethodCallActionNode) {
        this.currentNode = remoteMethodCallActionNode;
        this.currentIdentifierPos = this.nameRefPosition((NameReferenceNode)remoteMethodCallActionNode.methodName());
    }

    public void visit(FieldAccessExpressionNode fieldAccessExpressionNode) {
        this.currentNode = fieldAccessExpressionNode;
        this.currentIdentifierPos = this.nameRefPosition(fieldAccessExpressionNode.fieldName());
    }

    public void visit(ImplicitNewExpressionNode implicitNewExpressionNode) {
        this.currentNode = implicitNewExpressionNode;
        this.currentIdentifierPos = implicitNewExpressionNode.newKeyword().lineRange().startLine();
    }

    public void visit(ExplicitNewExpressionNode explicitNewExpressionNode) {
        this.currentNode = explicitNewExpressionNode;
        this.currentIdentifierPos = explicitNewExpressionNode.typeDescriptor().lineRange().startLine();
    }

    public void visit(ClassDefinitionNode classDefinitionNode) {
        this.currentNode = classDefinitionNode;
        this.currentIdentifierPos = classDefinitionNode.className().lineRange().startLine();
    }

    public void visit(VariableDeclarationNode varDeclrNodeNode) {
        this.currentNode = varDeclrNodeNode;
        this.currentIdentifierPos = varDeclrNodeNode.typedBindingPattern().bindingPattern().lineRange().startLine();
    }

    public void visit(ModuleVariableDeclarationNode modVarDeclrNodeNode) {
        this.currentNode = modVarDeclrNodeNode;
        this.currentIdentifierPos = modVarDeclrNodeNode.typedBindingPattern().bindingPattern().lineRange().startLine();
    }

    public void visit(ExpressionStatementNode expressionStatementNode) {
        this.visitScopedNodeMethod((Node)expressionStatementNode.expression());
    }

    public void visit(Node node) {
        boolean isRangeWithinNode;
        if (node == null) {
            return;
        }
        this.visitScopedNodeMethod(node);
        boolean bl = isRangeWithinNode = PositionUtil.isWithinLineRange(this.range.getStart(), node.lineRange()) && PositionUtil.isWithinLineRange(this.range.getEnd(), node.lineRange());
        if (!isRangeWithinNode) {
            this.visit((Node)node.parent());
        }
    }

    private void visitScopedNodeMethod(Node node) {
        Method visitMethod = SCOPED_NODE_TO_VISIT_METHOD.get(node.getClass());
        if (visitMethod != null) {
            try {
                visitMethod.invoke((Object)this, node);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    private LinePosition nameRefPosition(NameReferenceNode nameRef) {
        if (nameRef.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            QualifiedNameReferenceNode qualifiedNameRef = (QualifiedNameReferenceNode)nameRef;
            return qualifiedNameRef.colon().lineRange().endLine();
        }
        if (nameRef.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            SimpleNameReferenceNode simpleNameRef = (SimpleNameReferenceNode)nameRef;
            return simpleNameRef.name().lineRange().startLine();
        }
        return null;
    }
}

