/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagnosticBasedCodeActionProvider;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class AddAccessModifierCodeAction
implements DiagnosticBasedCodeActionProvider {
    public static final String NAME = "Add Access Modifier";

    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return DiagnosticErrorCode.MAIN_SHOULD_BE_PUBLIC.diagnosticId().equals(diagnostic.diagnosticInfo().code()) && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        Optional<FunctionDefinitionNode> funcDef = CodeActionUtil.getEnclosedFunction((Node)positionDetails.matchedNode());
        if (funcDef.isEmpty()) {
            return Collections.emptyList();
        }
        Position funcBodyStart = PositionUtil.toPosition(funcDef.get().functionKeyword().lineRange().startLine());
        String editText = "public ";
        List<TextEdit> edits = List.of(new TextEdit(new Range(funcBodyStart, funcBodyStart), editText));
        String commandTitle = "Convert to public function";
        return List.of(CodeActionUtil.createCodeAction(commandTitle, edits, context.fileUri(), "quickfix"));
    }

    public String getName() {
        return NAME;
    }
}

