/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.LineRange;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagnosticBasedCodeActionProvider;
import org.ballerinalang.util.diagnostic.DiagnosticWarningCode;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class AddExplicitReturnToFunctionCodeAction
implements DiagnosticBasedCodeActionProvider {
    private static final String NAME = "Add Explicit Return Statement";

    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return diagnostic.diagnosticInfo().code().equals(DiagnosticWarningCode.FUNCTION_SHOULD_EXPLICITLY_RETURN_A_VALUE.diagnosticId()) && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        NonTerminalNode currentNode = positionDetails.matchedNode();
        Optional<FunctionDefinitionNode> functionDefinition = this.getFunctionDefinition(currentNode);
        if (functionDefinition.isEmpty() || functionDefinition.get().functionBody().kind() != SyntaxKind.FUNCTION_BODY_BLOCK) {
            return Collections.emptyList();
        }
        FunctionBodyBlockNode functionBody = (FunctionBodyBlockNode)functionDefinition.get().functionBody();
        Token closeBraceToken = functionBody.closeBraceToken();
        Range range = PositionUtil.toRange(closeBraceToken.lineRange());
        String newText = this.getNewText(functionDefinition.get());
        String uri = context.filePath().toUri().toString();
        TextEdit textEdit = new TextEdit();
        textEdit.setRange(range);
        textEdit.setNewText(newText);
        List<TextEdit> textEdits = Collections.singletonList(textEdit);
        return Collections.singletonList(CodeActionUtil.createCodeAction(NAME, textEdits, uri, "quickfix"));
    }

    public String getName() {
        return NAME;
    }

    private Optional<FunctionDefinitionNode> getFunctionDefinition(NonTerminalNode node) {
        NonTerminalNode functionDef = null;
        NonTerminalNode parent = node;
        for (int i = 0; i < 3; ++i) {
            if ((parent = parent.parent()) == null || parent.isMissing()) {
                return Optional.empty();
            }
            functionDef = parent;
        }
        return functionDef.kind() == SyntaxKind.FUNCTION_DEFINITION || functionDef.kind() == SyntaxKind.OBJECT_METHOD_DEFINITION || functionDef.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION ? Optional.of((FunctionDefinitionNode)functionDef) : Optional.empty();
    }

    private String getNewText(FunctionDefinitionNode functionDef) {
        NodeList qualifiers = functionDef.qualifierList();
        Token kwFunction = functionDef.functionKeyword();
        FunctionBodyBlockNode functionBody = (FunctionBodyBlockNode)functionDef.functionBody();
        Token closeBraceToken = functionBody.closeBraceToken();
        LineRange startLineRange = qualifiers.isEmpty() ? kwFunction.lineRange() : ((Token)qualifiers.get(0)).lineRange();
        StringBuilder newText = new StringBuilder();
        if (startLineRange.startLine().line() == closeBraceToken.lineRange().startLine().line()) {
            newText.append(CommonUtil.LINE_SEPARATOR).append(StringUtils.repeat((String)" ", (int)(startLineRange.startLine().offset() + 4))).append("return;").append(CommonUtil.LINE_SEPARATOR).append(StringUtils.repeat((String)" ", (int)startLineRange.startLine().offset())).append("}");
        } else {
            newText.append(StringUtils.repeat((String)" ", (int)4)).append("return;").append(CommonUtil.LINE_SEPARATOR).append(StringUtils.repeat((String)" ", (int)startLineRange.startLine().offset())).append("}");
        }
        return newText.toString();
    }
}

