/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.syntax.tree.ExplicitAnonymousFunctionExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.projects.Project;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.LineRange;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.PathUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagnosticBasedCodeActionProvider;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class AddIsolatedQualifierCodeAction
implements DiagnosticBasedCodeActionProvider {
    public static final String NAME = "Add Isolated Qualifier";
    private static final String DIAGNOSTIC_CODE_3961 = "BCE3961";
    private static final String ANONYMOUS_FUNCTION_EXPRESSION = "Anonymous function expression";
    private static final Set<String> DIAGNOSTIC_CODES = Set.of("BCE3943", "BCE3946", "BCE3947", "BCE3950", "BCE3961");

    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return DIAGNOSTIC_CODES.contains(diagnostic.diagnosticInfo().code()) && CodeActionNodeValidator.validate(context.nodeAtRange()) && context.currentSyntaxTree().isPresent() && context.currentSemanticModel().isPresent();
    }

    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        NonTerminalNode nonTerminalNode = positionDetails.matchedNode();
        if (nonTerminalNode.kind() == SyntaxKind.EXPLICIT_ANONYMOUS_FUNCTION_EXPRESSION) {
            ExplicitAnonymousFunctionExpressionNode functionExpressionNode = (ExplicitAnonymousFunctionExpressionNode)nonTerminalNode;
            return AddIsolatedQualifierCodeAction.getCodeAction(functionExpressionNode.functionKeyword().lineRange(), ANONYMOUS_FUNCTION_EXPRESSION, context.fileUri());
        }
        if (CommonUtil.hasMultipleDiagnostics(context, nonTerminalNode, diagnostic, DIAGNOSTIC_CODES, DIAGNOSTIC_CODE_3961)) {
            return Collections.emptyList();
        }
        Optional<Symbol> optSymbol = AddIsolatedQualifierCodeAction.getReferredSymbol(context, nonTerminalNode);
        if (optSymbol.isEmpty()) {
            return Collections.emptyList();
        }
        Symbol symbol = optSymbol.get();
        if (symbol.getModule().isEmpty()) {
            return Collections.emptyList();
        }
        Optional project = context.workspace().project(context.filePath());
        if (project.isEmpty()) {
            return Collections.emptyList();
        }
        Optional<Path> optFilePath = PathUtil.getFilePathForSymbol(symbol, (Project)project.get(), (DocumentServiceContext)context);
        if (optFilePath.isEmpty()) {
            return Collections.emptyList();
        }
        Path filePath = optFilePath.get();
        if (context.workspace().syntaxTree(filePath).isEmpty()) {
            return Collections.emptyList();
        }
        Optional<NonTerminalNode> optNode = CommonUtil.findNode(symbol, (SyntaxTree)context.workspace().syntaxTree(filePath).get());
        if (optNode.isEmpty()) {
            return Collections.emptyList();
        }
        NonTerminalNode node = optNode.get();
        String symbolName = symbol.getName().orElse("");
        String filePathString = filePath.toUri().toString();
        return switch (node.kind()) {
            case SyntaxKind.FUNCTION_DEFINITION, SyntaxKind.OBJECT_METHOD_DEFINITION -> {
                FunctionDefinitionNode functionDefinitionNode = (FunctionDefinitionNode)node;
                yield AddIsolatedQualifierCodeAction.getCodeAction(functionDefinitionNode.functionKeyword().lineRange(), symbolName, filePathString);
            }
            case SyntaxKind.CAPTURE_BINDING_PATTERN -> {
                NonTerminalNode parentNode = node.parent();
                if (parentNode.kind() != SyntaxKind.TYPED_BINDING_PATTERN) {
                    yield Collections.emptyList();
                }
                TypedBindingPatternNode typeNode = (TypedBindingPatternNode)parentNode;
                yield AddIsolatedQualifierCodeAction.getCodeAction(typeNode.typeDescriptor().lineRange(), symbolName, filePathString);
            }
            default -> Collections.emptyList();
        };
    }

    private static Optional<Symbol> getReferredSymbol(CodeActionContext context, NonTerminalNode node) {
        SyntaxKind kind = node.kind();
        if (kind == SyntaxKind.EXPLICIT_NEW_EXPRESSION || kind == SyntaxKind.IMPLICIT_NEW_EXPRESSION) {
            try {
                TypeReferenceTypeSymbol typeSymbol = (TypeReferenceTypeSymbol)context.currentSemanticModel().flatMap(semanticModel -> semanticModel.typeOf((Node)node)).orElseThrow();
                ClassSymbol definition = (ClassSymbol)typeSymbol.definition();
                return Optional.of((Symbol)definition.initMethod().orElseThrow());
            }
            catch (RuntimeException e) {
                assert (false) : "This line is unreachable because the diagnostic is not produced otherwise.";
                return Optional.empty();
            }
        }
        return context.currentSemanticModel().flatMap(semanticModel -> semanticModel.symbol((Node)node));
    }

    private static List<CodeAction> getCodeAction(LineRange lineRange, String expressionName, String filePath) {
        Position position = PositionUtil.toPosition(lineRange.startLine());
        String editText = SyntaxKind.ISOLATED_KEYWORD.stringValue() + " ";
        TextEdit textEdit = new TextEdit(new Range(position, position), editText);
        String commandTitle = String.format("Add isolated qualifier to '%s'", expressionName);
        return Collections.singletonList(CodeActionUtil.createCodeAction(commandTitle, List.of(textEdit), filePath, "quickfix"));
    }

    public String getName() {
        return NAME;
    }
}

