/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.LinePosition;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextRange;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagnosticBasedCodeActionProvider;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class AddLockCodeAction
implements DiagnosticBasedCodeActionProvider {
    private static final String NAME = "Add lock";
    private static final Set<String> DIAGNOSTIC_CODES = Set.of("BCE3957", "BCE3962");

    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return DIAGNOSTIC_CODES.contains(diagnostic.diagnosticInfo().code()) && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        Optional<StatementNode> statementNode = AddLockCodeAction.getMatchingStatementNode((Node)positionDetails.matchedNode());
        if (statementNode.isEmpty()) {
            return Collections.emptyList();
        }
        List diagnostics = context.diagnostics(context.filePath());
        if (diagnostics.size() > 1 && AddLockCodeAction.hasMultipleIsolationVars(statementNode.get(), diagnostic, diagnostics)) {
            return Collections.emptyList();
        }
        TextEdit surroundWithLockEditText = AddLockCodeAction.getTextEdit((Node)statementNode.get());
        return Collections.singletonList(CodeActionUtil.createCodeAction("Surround with lock", List.of(surroundWithLockEditText), context.fileUri(), "quickfix"));
    }

    private static Optional<StatementNode> getMatchingStatementNode(Node matchedNode) {
        SyntaxKind kind;
        NonTerminalNode parentNode;
        for (parentNode = matchedNode.parent(); parentNode != null && !(parentNode instanceof StatementNode); parentNode = parentNode.parent()) {
            if (parentNode.kind() != SyntaxKind.START_ACTION) continue;
            return Optional.empty();
        }
        if (parentNode != null && parentNode.kind() == SyntaxKind.ASSIGNMENT_STATEMENT && ((kind = ((AssignmentStatementNode)parentNode).expression().kind()) == SyntaxKind.RECEIVE_ACTION || kind == SyntaxKind.START_ACTION)) {
            return Optional.empty();
        }
        return Optional.ofNullable((StatementNode)parentNode);
    }

    private static TextEdit getTextEdit(Node node) {
        TextDocument textDocument = node.syntaxTree().textDocument();
        TextRange textRange = node.textRangeWithMinutiae();
        LinePosition startLinePosition = textDocument.linePositionFrom(textRange.startOffset());
        LinePosition endLinePosition = textDocument.linePositionFrom(textRange.endOffset());
        Position startPosition = PositionUtil.toPosition(startLinePosition);
        Position endPosition = PositionUtil.toPosition(endLinePosition);
        String spaces = " ".repeat(node.lineRange().startLine().offset());
        String statement = node.toSourceCode();
        String indentedStatement = statement.substring(0, statement.length() - 1).replace("\n", "\n\t") + "\n";
        String editText = spaces + "lock {" + CommonUtil.LINE_SEPARATOR + "\t" + indentedStatement + spaces + "}\n";
        return new TextEdit(new Range(startPosition, endPosition), editText);
    }

    private static boolean hasMultipleIsolationVars(StatementNode statementNode, Diagnostic currentDiagnostic, List<Diagnostic> diagnostics) {
        return diagnostics.stream().anyMatch(diagnostic -> !currentDiagnostic.equals(diagnostic) && DIAGNOSTIC_CODES.contains(diagnostic.diagnosticInfo().code()) && PositionUtil.isWithinLineRange(diagnostic.location().lineRange(), statementNode.lineRange()));
    }

    public String getName() {
        return NAME;
    }
}

