/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagnosticBasedCodeActionProvider;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class AddReadonlyCodeAction
implements DiagnosticBasedCodeActionProvider {
    private static final String NAME = "Add readonly to the type";
    private static final String DIAGNOSTIC_CODE_3959 = "BCE3959";
    private static final Set<String> DIAGNOSTIC_CODES = Set.of("BCE3959", "BCE3960");

    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return DIAGNOSTIC_CODES.contains(diagnostic.diagnosticInfo().code()) && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        try {
            NonTerminalNode node = positionDetails.matchedNode();
            SemanticModel semanticModel = (SemanticModel)context.currentSemanticModel().orElseThrow();
            TypeSymbol typeSymbol = (TypeSymbol)semanticModel.typeOf((Node)node).orElseThrow();
            Location location = (Location)typeSymbol.getLocation().orElseThrow();
            if (CommonUtil.hasMultipleDiagnostics(context, node, diagnostic, DIAGNOSTIC_CODES, DIAGNOSTIC_CODE_3959)) {
                return Collections.emptyList();
            }
            if (typeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE) {
                return Collections.emptyList();
            }
            List<TextEdit> textEdits = AddReadonlyCodeAction.getReadonlyTextEdits(location.lineRange(), typeSymbol.typeKind() == TypeDescKind.UNION, node.kind() == SyntaxKind.INDEXED_EXPRESSION && typeSymbol.typeKind() != TypeDescKind.ARRAY);
            return Collections.singletonList(CodeActionUtil.createCodeAction(String.format("Add readonly to '%s'", typeSymbol.signature()), textEdits, context.fileUri(), "quickfix"));
        }
        catch (RuntimeException e) {
            return Collections.emptyList();
        }
    }

    private static List<TextEdit> getReadonlyTextEdits(LineRange lineRange, boolean encloseType, boolean encloseFull) {
        StringBuilder startText = new StringBuilder();
        StringBuilder endText = new StringBuilder();
        if (encloseType) {
            startText.append(SyntaxKind.OPEN_PAREN_TOKEN.stringValue());
            endText.append(SyntaxKind.CLOSE_PAREN_TOKEN.stringValue());
        }
        endText.append(" & ").append(SyntaxKind.READONLY_KEYWORD.stringValue());
        if (encloseFull) {
            startText.append(SyntaxKind.OPEN_PAREN_TOKEN.stringValue());
            endText.append(SyntaxKind.CLOSE_PAREN_TOKEN.stringValue());
        }
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        if (startText.length() > 0) {
            Position startPosition = PositionUtil.toPosition(lineRange.startLine());
            TextEdit startTextEdit = new TextEdit(new Range(startPosition, startPosition), startText.toString());
            textEdits.add(startTextEdit);
        }
        Position endPosition = PositionUtil.toPosition(lineRange.endLine());
        TextEdit endTextEdit = new TextEdit(new Range(endPosition, endPosition), endText.toString());
        textEdits.add(endTextEdit);
        return textEdits;
    }

    public String getName() {
        return NAME;
    }
}

