/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.ClassFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;
import org.ballerinalang.langserver.LSClientLogger;
import org.ballerinalang.langserver.LSContextOperation;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.DefaultValueGenerationUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedCodeActionProvider;
import org.ballerinalang.langserver.commons.codeaction.spi.RangeBasedPositionDetails;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class ConvertToQueryExpressionCodeAction
implements RangeBasedCodeActionProvider {
    private static final String TITLE = "Map with a query expression";

    public String getName() {
        return "CONVERT_TO_QUERY";
    }

    public boolean validate(CodeActionContext context, RangeBasedPositionDetails positionDetails) {
        return CodeActionNodeValidator.validate((Node)positionDetails.matchedCodeActionNode()) && context.currentSemanticModel().isPresent();
    }

    public List<CodeAction> getCodeActions(CodeActionContext context, RangeBasedPositionDetails posDetails) {
        Optional<String> defaultVal;
        NonTerminalNode matchedNode = posDetails.matchedCodeActionNode();
        Optional<LhsRhsSymbolInfo> optSymbolInfo = this.getLhsAndRhsSymbolInfo(matchedNode, context);
        if (optSymbolInfo.isEmpty()) {
            return Collections.emptyList();
        }
        LhsRhsSymbolInfo symbolInfo = optSymbolInfo.get();
        Symbol rhsSymbol = symbolInfo.rhsSymbol;
        Optional<TypeSymbol> rhsType = Optional.ofNullable(symbolInfo.rhsType);
        Optional<TypeSymbol> lhsType = Optional.ofNullable(symbolInfo.lhsType);
        if (rhsType.isEmpty() || lhsType.isEmpty() || rhsType.get().typeKind() != TypeDescKind.ARRAY || lhsType.get().typeKind() != TypeDescKind.ARRAY) {
            return Collections.emptyList();
        }
        TypeSymbol lhsMemberType = CommonUtil.getRawType(((ArrayTypeSymbol)lhsType.get()).memberTypeDescriptor());
        TypeSymbol rhsMemberType = CommonUtil.getRawType(((ArrayTypeSymbol)rhsType.get()).memberTypeDescriptor());
        String queryExpr = null;
        Range range = PositionUtil.toRange(symbolInfo.rhsNode.lineRange());
        if (rhsMemberType.subtypeOf(lhsMemberType)) {
            queryExpr = String.format("from var item in %s select item", symbolInfo.rhsNode.toSourceCode().strip());
        }
        if (queryExpr == null && lhsMemberType.typeKind() == TypeDescKind.RECORD && (defaultVal = DefaultValueGenerationUtil.getDefaultValueForType(lhsMemberType)).isPresent()) {
            queryExpr = String.format("from var item in %s select %s", symbolInfo.rhsNode.toSourceCode().strip(), defaultVal.get());
        }
        if (queryExpr == null) {
            String selectExpr = "item";
            queryExpr = String.format("from var item in %s select %s", rhsSymbol.getName().get(), selectExpr);
        }
        try {
            queryExpr = Formatter.format(queryExpr).trim();
        }
        catch (FormatterException e) {
            LSClientLogger.getInstance(context.languageServercontext()).logError(LSContextOperation.TXT_CODE_ACTION, "Failed to format query expression", e, null, new Position[]{null});
        }
        int offset = symbolInfo.lhsNode.lineRange().startLine().offset();
        CharSequence[] lines = queryExpr.split(CommonUtil.LINE_SEPARATOR);
        for (int i = 0; i < lines.length; ++i) {
            if (i <= 0) continue;
            lines[i] = StringUtils.repeat((char)' ', (int)offset) + (String)lines[i];
        }
        queryExpr = String.join((CharSequence)CommonUtil.LINE_SEPARATOR, lines);
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        edits.add(new TextEdit(range, queryExpr));
        CodeAction codeAction = CodeActionUtil.createCodeAction(TITLE, edits, context.fileUri(), "refactor.rewrite");
        return List.of(codeAction);
    }

    public List<SyntaxKind> getSyntaxKinds() {
        return List.of(SyntaxKind.LOCAL_VAR_DECL, SyntaxKind.SPECIFIC_FIELD, SyntaxKind.ASSIGNMENT_STATEMENT, SyntaxKind.FIELD_ACCESS, SyntaxKind.FUNCTION_CALL, SyntaxKind.METHOD_CALL);
    }

    private Optional<LhsRhsSymbolInfo> getLhsAndRhsSymbolInfo(NonTerminalNode matchedNode, CodeActionContext context) {
        Optional<Object> lhsSymbol = Optional.empty();
        Optional<Object> lhsType = Optional.empty();
        NonTerminalNode rhsNode = null;
        Node lhsNode = null;
        SemanticModel semanticModel = (SemanticModel)context.currentSemanticModel().get();
        do {
            if (matchedNode.kind() == SyntaxKind.LOCAL_VAR_DECL) {
                VariableDeclarationNode node = (VariableDeclarationNode)matchedNode;
                if (!node.initializer().isPresent()) break;
                rhsNode = (NonTerminalNode)node.initializer().get();
                lhsNode = node.typedBindingPattern();
                lhsSymbol = semanticModel.symbol(lhsNode).filter(symbol -> symbol.kind() == SymbolKind.VARIABLE);
                lhsType = lhsSymbol.map(symbol -> ((VariableSymbol)symbol).typeDescriptor());
                break;
            }
            if (matchedNode.kind() == SyntaxKind.ASSIGNMENT_STATEMENT) {
                AssignmentStatementNode assignmentStatementNode = (AssignmentStatementNode)matchedNode;
                if (assignmentStatementNode.varRef().kind() == SyntaxKind.FIELD_ACCESS) {
                    FieldAccessExpressionNode exprNode = (FieldAccessExpressionNode)assignmentStatementNode.varRef();
                    lhsNode = exprNode.fieldName();
                    lhsSymbol = semanticModel.symbol(lhsNode).filter(symbol -> symbol.kind() == SymbolKind.CLASS_FIELD || symbol.kind() == SymbolKind.RECORD_FIELD);
                    lhsType = lhsSymbol.map(symbol -> symbol.kind() == SymbolKind.CLASS_FIELD ? ((ClassFieldSymbol)symbol).typeDescriptor() : ((RecordFieldSymbol)symbol).typeDescriptor());
                } else {
                    lhsNode = assignmentStatementNode.varRef();
                    lhsSymbol = semanticModel.symbol(lhsNode).filter(symbol -> symbol.kind() == SymbolKind.VARIABLE);
                    lhsType = lhsSymbol.map(symbol -> ((VariableSymbol)symbol).typeDescriptor());
                }
                rhsNode = assignmentStatementNode.expression();
                break;
            }
            if (matchedNode.kind() != SyntaxKind.SPECIFIC_FIELD) continue;
            SpecificFieldNode specificFieldNode = (SpecificFieldNode)matchedNode;
            lhsNode = specificFieldNode.fieldName();
            rhsNode = (NonTerminalNode)specificFieldNode.valueExpr().get();
            lhsSymbol = semanticModel.symbol(lhsNode).filter(symbol -> symbol.kind() == SymbolKind.RECORD_FIELD);
            lhsType = lhsSymbol.map(symbol -> ((RecordFieldSymbol)symbol).typeDescriptor());
            break;
        } while ((matchedNode = matchedNode.parent()) != null && (matchedNode.kind() == SyntaxKind.LOCAL_VAR_DECL || matchedNode.kind() == SyntaxKind.ASSIGNMENT_STATEMENT || matchedNode.kind() == SyntaxKind.SPECIFIC_FIELD));
        if (matchedNode == null || rhsNode == null || lhsNode == null) {
            return Optional.empty();
        }
        Optional rhsSymbol = semanticModel.symbol((Node)rhsNode);
        Optional rhsType = semanticModel.typeOf((Node)rhsNode);
        if (rhsSymbol.isEmpty() || lhsSymbol.isEmpty() || lhsType.isEmpty() || rhsType.isEmpty()) {
            return Optional.empty();
        }
        LhsRhsSymbolInfo nodeInfo = new LhsRhsSymbolInfo((Symbol)rhsSymbol.get(), (TypeSymbol)lhsType.get(), (TypeSymbol)rhsType.get(), rhsNode, lhsNode);
        return Optional.of(nodeInfo);
    }

    static class LhsRhsSymbolInfo {
        private final Symbol rhsSymbol;
        private final TypeSymbol lhsType;
        private final TypeSymbol rhsType;
        private final NonTerminalNode rhsNode;
        private final Node lhsNode;

        public LhsRhsSymbolInfo(Symbol rhsSymbol, TypeSymbol lhsType, TypeSymbol rhsType, NonTerminalNode rhsNode, Node lhsNode) {
            this.rhsSymbol = rhsSymbol;
            this.lhsType = lhsType;
            this.rhsType = rhsType;
            this.rhsNode = rhsNode;
            this.lhsNode = lhsNode;
        }
    }
}

