/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.StartActionNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.LineRange;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.LSContextOperation;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.command.visitors.FunctionCallExpressionTypeFinder;
import org.ballerinalang.langserver.command.visitors.IsolatedBlockResolver;
import org.ballerinalang.langserver.common.constants.CommandConstants;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.FunctionGenerator;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.ballerinalang.langserver.common.utils.PathUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.CodeActionResolveContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.codeaction.CodeActionData;
import org.ballerinalang.langserver.commons.codeaction.ResolvableCodeAction;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagnosticBasedCodeActionProvider;
import org.ballerinalang.langserver.commons.codeaction.spi.ResolvableCodeActionProvider;
import org.ballerinalang.langserver.commons.command.CommandArgument;
import org.ballerinalang.langserver.contexts.ContextBuilder;
import org.ballerinalang.langserver.exception.UserErrorException;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentEdit;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class CreateFunctionCodeAction
implements DiagnosticBasedCodeActionProvider,
ResolvableCodeActionProvider {
    public static final String NAME = "Create Function";
    private static final String UNDEFINED_FUNCTION = "undefined function";

    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        boolean isWithinFile;
        Optional<FunctionCallExpressionNode> callExpr = CreateFunctionCodeAction.checkAndGetFunctionCallExpressionNode(positionDetails.matchedNode());
        if (callExpr.isEmpty() || this.isInvalidReturnType(context, callExpr.get())) {
            return Collections.emptyList();
        }
        String diagnosticMessage = diagnostic.message();
        Range range = PositionUtil.toRange(diagnostic.location().lineRange());
        String uri = context.fileUri();
        CommandArgument posArg = CommandArgument.from((String)"node.range", (Object)range);
        Matcher matcher = CommandConstants.UNDEFINED_FUNCTION_PATTERN.matcher(diagnosticMessage);
        String functionName = matcher.find() && matcher.groupCount() > 0 ? matcher.group(1) + "(...)" : "";
        boolean bl = isWithinFile = callExpr.get().functionName().kind() == SyntaxKind.SIMPLE_NAME_REFERENCE;
        if (isWithinFile) {
            String commandTitle = String.format("Create function '%s'", functionName);
            CodeActionData codeActionData = new CodeActionData(this.getName(), uri, range, (Object)posArg);
            ResolvableCodeAction action = CodeActionUtil.createResolvableCodeAction(commandTitle, "quickfix", codeActionData);
            action.setDiagnostics(CodeActionUtil.toDiagnostics(Collections.singletonList(diagnostic)));
            return Collections.singletonList(action);
        }
        return Collections.emptyList();
    }

    public String getName() {
        return NAME;
    }

    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        if (!diagnostic.message().startsWith(UNDEFINED_FUNCTION) || positionDetails.matchedNode() == null) {
            return false;
        }
        return CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    public static Optional<FunctionCallExpressionNode> checkAndGetFunctionCallExpressionNode(NonTerminalNode node) {
        StartActionNode startActionNode;
        FunctionCallExpressionNode functionCallExpressionNode = null;
        if (node.kind() == SyntaxKind.FUNCTION_CALL) {
            functionCallExpressionNode = (FunctionCallExpressionNode)node;
        }
        if (functionCallExpressionNode != null) {
            return Optional.of(functionCallExpressionNode);
        }
        if (node.kind() == SyntaxKind.START_ACTION && (startActionNode = (StartActionNode)node).expression().kind() == SyntaxKind.FUNCTION_CALL) {
            functionCallExpressionNode = (FunctionCallExpressionNode)startActionNode.expression();
        }
        return Optional.ofNullable(functionCallExpressionNode);
    }

    private boolean isInvalidReturnType(CodeActionContext context, FunctionCallExpressionNode callExpr) {
        SemanticModel semanticModel = (SemanticModel)context.currentSemanticModel().get();
        FunctionCallExpressionTypeFinder typeFinder = new FunctionCallExpressionTypeFinder(semanticModel, callExpr);
        callExpr.accept((NodeVisitor)typeFinder);
        Optional<TypeSymbol> returnTypeSymbol = typeFinder.getReturnTypeSymbol();
        return callExpr.parent().kind() != SyntaxKind.CALL_STATEMENT && returnTypeSymbol.isPresent() && (returnTypeSymbol.get().typeKind() == TypeDescKind.COMPILATION_ERROR || returnTypeSymbol.get().typeKind() == TypeDescKind.NONE);
    }

    public CodeAction resolve(ResolvableCodeAction codeAction, CodeActionResolveContext resolveContext) {
        Range insertRange;
        String uri = codeAction.getData().getFileUri();
        Optional<Path> filePath = PathUtil.getPathFromURI(uri);
        if (filePath.isEmpty()) {
            throw new UserErrorException("Invalid file URI provided for the create function code action!");
        }
        SyntaxTree syntaxTree = (SyntaxTree)resolveContext.workspace().syntaxTree(filePath.get()).orElseThrow();
        NonTerminalNode cursorNode = CommonUtil.findNode(codeAction.getData().getRange(), syntaxTree);
        if (cursorNode == null) {
            throw new UserErrorException("Failed to resolve code action");
        }
        Optional<FunctionCallExpressionNode> fnCallExprNode = CreateFunctionCodeAction.checkAndGetFunctionCallExpressionNode(cursorNode);
        if (fnCallExprNode.isEmpty()) {
            throw new UserErrorException("Couldn't find a matching function call expression");
        }
        SemanticModel semanticModel = (SemanticModel)resolveContext.workspace().semanticModel(filePath.get()).orElseThrow();
        LineRange rootLineRange = syntaxTree.rootNode().lineRange();
        int endLine = rootLineRange.endLine().line() + 1;
        int endCol = 0;
        boolean newLineAtEnd = rootLineRange.endLine().offset() == 0;
        Set<String> visibleSymbolNames = resolveContext.visibleSymbols(new Position(endLine, endCol)).stream().map(Symbol::getName).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        DocumentServiceContext docServiceContext = ContextBuilder.buildDocumentServiceContext(uri, resolveContext.workspace(), LSContextOperation.WS_EXEC_CMD, resolveContext.languageServercontext());
        ArrayList<String> args = new ArrayList<String>();
        int argIndex = 1;
        List<SymbolKind> argumentKindList = Arrays.asList(SymbolKind.VARIABLE, SymbolKind.CONSTANT);
        for (FunctionArgumentNode fnArgNode : fnCallExprNode.get().arguments()) {
            Optional type = semanticModel.typeOf((Node)fnArgNode);
            Optional symbol = fnArgNode.kind() == SyntaxKind.POSITIONAL_ARG ? semanticModel.symbol((Node)((PositionalArgumentNode)fnArgNode).expression()) : semanticModel.symbol((Node)fnArgNode);
            String varName = "";
            if (symbol.isPresent() && argumentKindList.contains(((Symbol)symbol.get()).kind())) {
                varName = ((Symbol)symbol.get()).getName().orElse("");
            }
            if (fnArgNode.kind() == SyntaxKind.NAMED_ARG) {
                NamedArgumentNode namedArgumentNode = (NamedArgumentNode)fnArgNode;
                type = semanticModel.typeOf((Node)namedArgumentNode.expression());
                varName = namedArgumentNode.argumentName().name().text();
            }
            if (type.isPresent() && ((TypeSymbol)type.get()).typeKind() != TypeDescKind.COMPILATION_ERROR) {
                varName = NameUtil.generateParameterName(varName, argIndex, CommonUtil.getRawType((TypeSymbol)type.get()), visibleSymbolNames);
                args.add(FunctionGenerator.getParameterTypeAsString(docServiceContext, (TypeSymbol)type.get()) + " " + varName);
            } else {
                varName = NameUtil.generateParameterName(varName, argIndex, null, visibleSymbolNames);
                args.add(FunctionGenerator.getParameterTypeAsString(docServiceContext, null) + " " + varName);
            }
            visibleSymbolNames.add(varName);
            ++argIndex;
        }
        if (fnCallExprNode.get().functionName().kind() != SyntaxKind.SIMPLE_NAME_REFERENCE) {
            throw new UserErrorException("Failed to resolve code action");
        }
        String functionName = ((SimpleNameReferenceNode)fnCallExprNode.get().functionName()).name().text();
        if (functionName.isEmpty()) {
            throw new UserErrorException("Failed to resolve code action");
        }
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        Optional<NonTerminalNode> enclosingNode = this.findEnclosingModulePartNode((NonTerminalNode)fnCallExprNode.get());
        if (enclosingNode.isPresent()) {
            newLineAtEnd = CodeActionUtil.addNewLineAtEnd((Node)enclosingNode.get());
            insertRange = PositionUtil.toRange(enclosingNode.get().lineRange().endLine());
        } else {
            insertRange = new Range(new Position(endLine, endCol), new Position(endLine, endCol));
        }
        FunctionCallExpressionTypeFinder typeFinder = new FunctionCallExpressionTypeFinder(semanticModel, fnCallExprNode.get());
        fnCallExprNode.get().accept((NodeVisitor)typeFinder);
        Optional<TypeSymbol> returnTypeSymbol = typeFinder.getReturnTypeSymbol();
        IsolatedBlockResolver isolatedBlockResolver = new IsolatedBlockResolver();
        Boolean isIsolated = isolatedBlockResolver.findIsolatedBlock((Node)fnCallExprNode.get());
        if (!returnTypeSymbol.isPresent()) {
            throw new UserErrorException("Failed to resolve code action");
        }
        String function = FunctionGenerator.generateFunction(docServiceContext, newLineAtEnd, functionName, args, returnTypeSymbol.get(), isIsolated);
        edits.add(new TextEdit(insertRange, function));
        TextDocumentEdit textDocumentEdit = new TextDocumentEdit(new VersionedTextDocumentIdentifier(uri, null), edits);
        codeAction.setEdit(new WorkspaceEdit(Collections.singletonList(Either.forLeft((Object)textDocumentEdit))));
        return codeAction;
    }

    private Optional<NonTerminalNode> findEnclosingModulePartNode(NonTerminalNode node) {
        for (NonTerminalNode reference = node; reference != null && reference.parent() != null; reference = reference.parent()) {
            if (reference.parent().kind() != SyntaxKind.MODULE_PART) continue;
            return Optional.of(reference);
        }
        return Optional.empty();
    }
}

