/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.PathUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagnosticBasedCodeActionProvider;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class CreateTypeCodeAction
implements DiagnosticBasedCodeActionProvider {
    private static final int DIAG_PROP_UNKNOWN_TYPE_NAME_INDEX = 0;

    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return DiagnosticErrorCode.UNKNOWN_TYPE.diagnosticId().equals(diagnostic.diagnosticInfo().code()) && positionDetails.matchedNode().kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        Optional name = positionDetails.diagnosticProperty(0);
        Range diagRange = PathUtil.getRange(diagnostic.location());
        Optional<NonTerminalNode> node = context.currentSyntaxTree().map(syntaxTree -> CommonUtil.findNode(diagRange, syntaxTree));
        if (node.isEmpty() || name.isEmpty()) {
            return Collections.emptyList();
        }
        Node tlNode = (Node)node.get();
        boolean isReturnType = false;
        while (tlNode.parent().kind() != SyntaxKind.MODULE_PART) {
            if (tlNode.kind() == SyntaxKind.RETURN_TYPE_DESCRIPTOR) {
                isReturnType = true;
            }
            tlNode = tlNode.parent();
        }
        Range range = new Range(PositionUtil.toPosition(tlNode.lineRange().startLine()), PositionUtil.toPosition(tlNode.lineRange().startLine()));
        String paddingStr = StringUtils.repeat((String)" ", (int)4);
        String closedRecord = "type %s record {%s%n%s%n%s};%n%n".formatted(name.get(), isReturnType ? "|" : "", paddingStr, isReturnType ? "|" : "");
        String title = String.format("Create record '%s'", name.get());
        CodeAction codeAction = CodeActionUtil.createCodeAction(title, List.of(new TextEdit(range, closedRecord)), context.fileUri(), "quickfix");
        return List.of(codeAction);
    }

    public String getName() {
        return "CreateType";
    }
}

