/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.codeaction.providers.AbstractImplementMethodCodeAction;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagnosticBasedCodeActionProvider;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.TextEdit;

public class ImplementMethodCodeAction
extends AbstractImplementMethodCodeAction
implements DiagnosticBasedCodeActionProvider {
    public static final String NAME = "Implement Method";

    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return DIAGNOSTIC_CODES.contains(diagnostic.diagnosticInfo().code()) && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>(ImplementMethodCodeAction.getDiagBasedTextEdits(positionDetails, context));
        if (!edits.isEmpty() && positionDetails.diagnosticProperty(0).isPresent()) {
            String commandTitle = String.format("Implement method '%s'", positionDetails.diagnosticProperty(0).get());
            CodeAction quickFixCodeAction = CodeActionUtil.createCodeAction(commandTitle, edits, context.fileUri(), "quickfix");
            quickFixCodeAction.setDiagnostics(CodeActionUtil.toDiagnostics(Collections.singletonList(diagnostic)));
            return Collections.singletonList(quickFixCodeAction);
        }
        return Collections.emptyList();
    }

    public String getName() {
        return NAME;
    }
}

