/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.syntax.tree.AnnotationDeclarationNode;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagnosticBasedCodeActionProvider;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class MakeAnnotationDeclConstantCodeAction
implements DiagnosticBasedCodeActionProvider {
    public static final String NAME = "Make Annotation Declaration Constant";
    public static final String DIAGNOSTIC_CODE = "BCE2638";

    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return DIAGNOSTIC_CODE.equals(diagnostic.diagnosticInfo().code()) && context.currentSyntaxTree().isPresent() && context.currentSemanticModel().isPresent() && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        Optional project = context.workspace().project(context.filePath());
        if (project.isEmpty()) {
            return Collections.emptyList();
        }
        Range diagnosticRange = PositionUtil.toRange(diagnostic.location().lineRange());
        NonTerminalNode node = CommonUtil.findNode(diagnosticRange, (SyntaxTree)context.currentSyntaxTree().get());
        if (node.kind() != SyntaxKind.ANNOTATION_DECLARATION) {
            return Collections.emptyList();
        }
        AnnotationDeclarationNode annotationDeclarationNode = (AnnotationDeclarationNode)node;
        Position position = PositionUtil.toPosition(annotationDeclarationNode.annotationKeyword().lineRange().startLine());
        TextEdit textEdit = new TextEdit(new Range(position, position), SyntaxKind.CONST_KEYWORD.stringValue() + " ");
        String commandTitle = String.format("Convert '%s' to constant", annotationDeclarationNode.annotationTag().toString().strip());
        return Collections.singletonList(CodeActionUtil.createCodeAction(commandTitle, List.of(textEdit), context.fileUri(), "quickfix"));
    }

    public String getName() {
        return NAME;
    }
}

