/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers;

import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.projects.Project;
import io.ballerina.projects.ProjectKind;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.Location;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagnosticBasedCodeActionProvider;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class ModVarToListenerDeclCodeAction
implements DiagnosticBasedCodeActionProvider {
    public static final String NAME = "Module var to listener declaration";

    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return DiagnosticErrorCode.INVALID_LISTENER_ATTACHMENT.diagnosticId().equals(diagnostic.diagnosticInfo().code()) && positionDetails.matchedNode() != null && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        NonTerminalNode matchedNode = positionDetails.matchedNode();
        Optional<Pair<CaptureBindingPatternNode, String>> nodeUriPair = this.findCaptureBindingPattern((Node)matchedNode, context);
        if (nodeUriPair.isEmpty() || ((CaptureBindingPatternNode)nodeUriPair.get().getLeft()).parent().kind() != SyntaxKind.TYPED_BINDING_PATTERN) {
            return Collections.emptyList();
        }
        TypedBindingPatternNode typedBindingPatternNode = (TypedBindingPatternNode)((CaptureBindingPatternNode)nodeUriPair.get().getLeft()).parent();
        ArrayList<CodeAction> actions = new ArrayList<CodeAction>();
        ArrayList<TextEdit> textEdits = new ArrayList<TextEdit>();
        Position pos = PositionUtil.toRange(typedBindingPatternNode.lineRange()).getStart();
        Position insertPos = new Position(pos.getLine(), pos.getCharacter());
        textEdits.add(new TextEdit(new Range(insertPos, insertPos), SyntaxKind.LISTENER_KEYWORD.stringValue().trim() + " "));
        String commandTitle = String.format("Convert module variable '%s' to listener declaration", matchedNode.toSourceCode().trim());
        actions.add(CodeActionUtil.createCodeAction(commandTitle, textEdits, (String)nodeUriPair.get().getRight(), "quickfix"));
        return actions;
    }

    private Optional<Pair<CaptureBindingPatternNode, String>> findCaptureBindingPattern(Node matchedNode, CodeActionContext context) {
        String uri;
        Optional<NonTerminalNode> foundNode;
        Optional symbol = context.currentSemanticModel().flatMap(semanticModel -> semanticModel.symbol(matchedNode));
        if (symbol.isEmpty() || context.currentSyntaxTree().isEmpty() || !SymbolUtil.isListener((Symbol)symbol.get())) {
            return Optional.empty();
        }
        if (matchedNode.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            Optional project = context.workspace().project(context.filePath());
            Optional location = ((Symbol)symbol.get()).getLocation();
            if (location.isEmpty() || project.isEmpty() || ((Project)project.get()).kind() != ProjectKind.BUILD_PROJECT || ((Symbol)symbol.get()).getModule().isEmpty()) {
                return Optional.empty();
            }
            Path filePath = ((Project)project.get()).sourceRoot().resolve("modules").resolve(((ModuleSymbol)((Symbol)symbol.get()).getModule().get()).id().modulePrefix()).resolve(((Location)location.get()).lineRange().fileName());
            Optional syntaxTree = context.workspace().syntaxTree(filePath);
            if (syntaxTree.isEmpty()) {
                return Optional.empty();
            }
            foundNode = CommonUtil.findNode((Symbol)symbol.get(), (SyntaxTree)syntaxTree.get());
            uri = filePath.toUri().toString();
        } else {
            foundNode = CommonUtil.findNode((Symbol)symbol.get(), (SyntaxTree)context.currentSyntaxTree().get());
            uri = context.fileUri();
        }
        if (foundNode.isEmpty() || foundNode.get().kind() != SyntaxKind.CAPTURE_BINDING_PATTERN) {
            return Optional.empty();
        }
        return Optional.of(Pair.of((Object)((CaptureBindingPatternNode)foundNode.get()), (Object)uri));
    }

    public String getName() {
        return NAME;
    }
}

