/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers.changetype;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.Types;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TemplateExpressionNode;
import io.ballerina.projects.Document;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.LinePosition;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagnosticBasedCodeActionProvider;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.TextEdit;

public class ConvertToXmlOrStringTemplateCodeAction
implements DiagnosticBasedCodeActionProvider {
    public static final String NAME = "Change subtype of a raw template";
    public static final String DIAGNOSTIC_CODE = "BCE3936";

    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return DIAGNOSTIC_CODE.equals(diagnostic.diagnosticInfo().code()) && CodeActionNodeValidator.validate(context.nodeAtRange()) && context.currentSemanticModel().isPresent() && positionDetails.matchedNode().parent().kind() != SyntaxKind.CONST_DECLARATION;
    }

    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        TemplateExpressionNode templateExpressionNode = (TemplateExpressionNode)positionDetails.matchedNode();
        Node node = context.nodeAtRange();
        LinePosition linePosition = node.location().lineRange().endLine();
        Optional typeSymbol = Optional.empty();
        if (context.currentSemanticModel().isPresent() && context.currentDocument().isPresent()) {
            typeSymbol = ((SemanticModel)context.currentSemanticModel().get()).expectedType((Document)context.currentDocument().get(), linePosition);
        }
        HashSet<String> typeSet = new HashSet<String>();
        if (typeSymbol.isPresent()) {
            if (((TypeSymbol)typeSymbol.get()).typeKind() == TypeDescKind.UNION) {
                UnionTypeSymbol unionTypeSymbol = (UnionTypeSymbol)typeSymbol.get();
                Types types = ((SemanticModel)context.currentSemanticModel().get()).types();
                if (unionTypeSymbol.memberTypeDescriptors().contains(types.STRING)) {
                    typeSet.add("string");
                }
                if (unionTypeSymbol.memberTypeDescriptors().contains(types.XML)) {
                    typeSet.add("xml");
                }
                if (unionTypeSymbol.memberTypeDescriptors().contains(types.REGEX)) {
                    typeSet.add("re");
                }
            } else if (((TypeSymbol)typeSymbol.get()).typeKind() == TypeDescKind.STRING) {
                typeSet.add("string");
            } else if (((TypeSymbol)typeSymbol.get()).typeKind() == TypeDescKind.XML) {
                typeSet.add("xml");
            } else if (this.isRegexTemplate((TypeSymbol)typeSymbol.get())) {
                typeSet.add("re");
            }
        }
        if (typeSet.isEmpty()) {
            typeSet.addAll(Set.of("string", "xml", "re"));
        }
        ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
        typeSet.forEach(type -> {
            ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
            String editText = type + " " + templateExpressionNode.toSourceCode().strip();
            edits.add(new TextEdit(PositionUtil.toRange(templateExpressionNode.lineRange()), editText));
            String commandTitle = String.format("Convert to '%s' template", type);
            codeActions.add(CodeActionUtil.createCodeAction(commandTitle, edits, context.fileUri(), "quickfix"));
        });
        return codeActions;
    }

    private boolean isRegexTemplate(TypeSymbol typeSymbol) {
        if ((typeSymbol = CommonUtil.getRawType(typeSymbol)).typeKind() == TypeDescKind.TYPE_REFERENCE) {
            typeSymbol = CommonUtil.getRawType(typeSymbol);
        }
        return typeSymbol.typeKind() == TypeDescKind.REGEXP;
    }

    public String getName() {
        return NAME;
    }
}

