/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers.createvar;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.WorkerSymbol;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.ImportsAcceptor;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.capability.LSClientCapabilities;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagnosticBasedCodeActionProvider;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class CreateVariableCodeAction
implements DiagnosticBasedCodeActionProvider {
    public static final String NAME = "Create Variable";

    public int priority() {
        return 999;
    }

    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return diagnostic.message().contains("variable assignment is required") && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        Optional<TypeSymbol> typeSymbol = this.getExpectedTypeSymbol(positionDetails);
        if (typeSymbol.isEmpty() || typeSymbol.get().typeKind() == TypeDescKind.NONE || this.isCompilationErrorTyped(typeSymbol.get())) {
            return Collections.emptyList();
        }
        String uri = context.fileUri();
        Range range = PositionUtil.toRange(diagnostic.location().lineRange());
        CreateVariableOut createVarTextEdits = this.getCreateVariableTextEdits(range, positionDetails, typeSymbol.get(), context, new ImportsAcceptor((DocumentServiceContext)context));
        List<String> types = createVarTextEdits.types;
        ArrayList<CodeAction> actions = new ArrayList<CodeAction>();
        for (int i = 0; i < types.size(); ++i) {
            String commandTitle = "Create variable";
            ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
            TextEdit variableEdit = createVarTextEdits.edits.get(i);
            edits.add(variableEdit);
            edits.addAll(createVarTextEdits.imports);
            String type = types.get(i);
            if (createVarTextEdits.types.size() > 1) {
                boolean isTuple = type.startsWith("[") && type.endsWith("]") && !type.endsWith("[]");
                String typeLabel = isTuple && type.length() > 10 ? "Tuple" : type;
                commandTitle = String.format("Create variable with '%s'", typeLabel);
            }
            CodeAction codeAction = CodeActionUtil.createCodeAction(commandTitle, edits, uri, "quickfix");
            this.addRenamePopup(context, codeAction, createVarTextEdits.varRenamePosition.get(i), createVarTextEdits.imports.size());
            actions.add(codeAction);
        }
        return actions;
    }

    private boolean isCompilationErrorTyped(TypeSymbol typeSymbol) {
        if (typeSymbol.typeKind() == TypeDescKind.UNION) {
            return this.isCompilationErrorTyped((UnionTypeSymbol)typeSymbol);
        }
        return typeSymbol.typeKind() == TypeDescKind.COMPILATION_ERROR;
    }

    protected boolean isCompilationErrorTyped(UnionTypeSymbol unionTypeSymbol) {
        return unionTypeSymbol.memberTypeDescriptors().stream().anyMatch(tSymbol -> tSymbol.typeKind() == TypeDescKind.COMPILATION_ERROR);
    }

    public String getName() {
        return NAME;
    }

    protected CreateVariableOut getCreateVariableTextEdits(Range range, DiagBasedPositionDetails positionDetails, TypeSymbol typeDescriptor, CodeActionContext context, ImportsAcceptor importsAcceptor) {
        Symbol matchedSymbol = positionDetails.matchedSymbol();
        Position position = PositionUtil.toPosition(positionDetails.matchedNode().lineRange().startLine());
        Set<String> allNameEntries = context.visibleSymbols(position).stream().filter(s -> s.getName().isPresent()).map(s -> (String)s.getName().get()).collect(Collectors.toSet());
        String name = NameUtil.generateVariableName(matchedSymbol, typeDescriptor, allNameEntries);
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        ArrayList<Integer> renamePositions = new ArrayList<Integer>();
        List<String> types = CodeActionUtil.getPossibleTypes(typeDescriptor, context, importsAcceptor);
        Position insertPos = range.getStart();
        ArrayList<Position> varRenamePositions = new ArrayList<Position>();
        for (String type : types) {
            String edit = type + " " + name + " = ";
            edits.add(new TextEdit(new Range(insertPos, insertPos), edit));
            renamePositions.add(type.length() + 1);
            varRenamePositions.add(new Position(insertPos.getLine(), insertPos.getCharacter() + type.length() + 1));
        }
        return new CreateVariableOut(name, types, edits, importsAcceptor.getNewImportTextEdits(), renamePositions, varRenamePositions);
    }

    protected Optional<TypeSymbol> getExpectedTypeSymbol(DiagBasedPositionDetails positionDetails) {
        Optional symbol = positionDetails.diagnosticProperty(CodeActionUtil.getDiagPropertyFilterFunction(0));
        if (symbol.isEmpty()) {
            return Optional.empty();
        }
        TypeSymbol typeSymbol = null;
        if (symbol.get() instanceof TypeSymbol) {
            typeSymbol = (TypeSymbol)symbol.get();
        }
        if (((Symbol)symbol.get()).kind() == SymbolKind.WORKER) {
            WorkerSymbol workerSymbol = (WorkerSymbol)symbol.get();
            typeSymbol = workerSymbol.returnType();
        }
        return Optional.ofNullable(typeSymbol);
    }

    public void addRenamePopup(CodeActionContext context, CodeAction codeAction, Position varRenamePosition, int newImportsCount) {
        LSClientCapabilities lsClientCapabilities = (LSClientCapabilities)context.languageServercontext().get(LSClientCapabilities.class);
        if (lsClientCapabilities.getInitializationOptions().isPositionalRefactorRenameSupported()) {
            codeAction.setCommand(new Command("Rename variable", "ballerina.action.positional.rename", List.of(context.fileUri(), new Position(varRenamePosition.getLine() + newImportsCount, varRenamePosition.getCharacter()))));
        }
    }

    static class CreateVariableOut {
        String name;
        List<String> types;
        List<TextEdit> edits;
        List<TextEdit> imports;
        List<Integer> renamePositions;
        List<Position> varRenamePosition;

        public CreateVariableOut(String name, List<String> types, List<TextEdit> edits, List<TextEdit> imports, List<Integer> renamePositions, List<Position> varRenamePosition) {
            this.name = name;
            this.types = types;
            this.edits = edits;
            this.imports = imports;
            this.renamePositions = renamePositions;
            this.varRenamePosition = varRenamePosition;
        }
    }
}

