/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers.createvar;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.Types;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.ClientResourceAccessActionNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.RemoteMethodCallActionNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.codeaction.providers.createvar.CreateVariableCodeAction;
import org.ballerinalang.langserver.common.ImportsAcceptor;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.FunctionGenerator;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class CreateVariableWithTypeCodeAction
extends CreateVariableCodeAction {
    private static final String NAME = "Create variable with type";
    private static final String DIAGNOSTIC_CODE = "BCE4038";

    @Override
    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return diagnostic.diagnosticInfo().code().equals(DIAGNOSTIC_CODE) && context.currentSemanticModel().isPresent() && this.isInRemoteMethodCallOrResourceAccess(context) && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    @Override
    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        Optional<NonTerminalNode> actionNode = this.getActionNode(context);
        if (actionNode.isEmpty() || !this.isInActionStatement(actionNode.get())) {
            return Collections.emptyList();
        }
        Optional<TypeSymbol> typeSymbol = this.getReturnTypeOfAction(actionNode.get(), context);
        if (typeSymbol.isEmpty() || typeSymbol.get().typeKind() == TypeDescKind.ANY) {
            return Collections.emptyList();
        }
        LineRange actionLineRange = actionNode.get().lineRange();
        if (actionNode.get().parent().kind() == SyntaxKind.CHECK_EXPRESSION || actionNode.get().parent().kind() == SyntaxKind.CHECK_ACTION) {
            actionLineRange = actionNode.get().parent().lineRange();
        }
        String uri = context.fileUri();
        Range actionRange = PositionUtil.toRange(actionLineRange);
        CreateVariableCodeAction.CreateVariableOut createVarTextEdits = this.getCreateVariableTextEdits(actionRange, positionDetails, typeSymbol.get(), context, new ImportsAcceptor((DocumentServiceContext)context));
        List<String> types = createVarTextEdits.types;
        ArrayList<CodeAction> codeActions = new ArrayList<CodeAction>();
        for (int i = 0; i < types.size(); ++i) {
            String commandTitle = "Create variable";
            ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
            TextEdit variableEdit = createVarTextEdits.edits.get(i);
            edits.add(variableEdit);
            edits.addAll(createVarTextEdits.imports);
            String type = types.get(i);
            if (createVarTextEdits.types.size() > 1) {
                boolean isTuple = type.startsWith("[") && type.endsWith("]") && !type.endsWith("[]");
                String typeLabel = isTuple && type.length() > 10 ? "Tuple" : type;
                commandTitle = String.format("Create variable with '%s'", typeLabel);
            }
            codeActions.add(CodeActionUtil.createCodeAction(commandTitle, edits, uri, "quickfix"));
        }
        return codeActions;
    }

    @Override
    protected CreateVariableCodeAction.CreateVariableOut getCreateVariableTextEdits(Range range, DiagBasedPositionDetails posDetails, TypeSymbol typeDescriptor, CodeActionContext context, ImportsAcceptor importsAcceptor) {
        Symbol matchedSymbol = posDetails.matchedSymbol();
        Position position = PositionUtil.toPosition(posDetails.matchedNode().lineRange().startLine());
        Set<String> allNameEntries = context.visibleSymbols(position).stream().filter(s -> s.getName().isPresent()).map(s -> (String)s.getName().get()).collect(Collectors.toSet());
        String name = NameUtil.generateVariableName(matchedSymbol, typeDescriptor, allNameEntries);
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        ArrayList<Integer> renamePositions = new ArrayList<Integer>();
        List<String> types = this.getPossibleTypes(typeDescriptor, context, importsAcceptor);
        Position insertPos = range.getStart();
        ArrayList<Position> varRenamePositions = new ArrayList<Position>();
        for (String type : types) {
            String edit = type + " " + name + " = ";
            edits.add(new TextEdit(new Range(insertPos, insertPos), edit));
            renamePositions.add(type.length() + 1);
            varRenamePositions.add(new Position(insertPos.getLine(), insertPos.getCharacter() + type.length() + 1));
        }
        return new CreateVariableCodeAction.CreateVariableOut(name, types, edits, importsAcceptor.getNewImportTextEdits(), renamePositions, varRenamePositions);
    }

    private List<String> getPossibleTypes(TypeSymbol typeSymbol, CodeActionContext context, ImportsAcceptor importsAcceptor) {
        typeSymbol = this.getRawType(typeSymbol, context);
        HashSet possibleTypes = new HashSet();
        HashSet unionTypes = new HashSet();
        String unionType = null;
        ArrayList errorTypes = new ArrayList();
        if (typeSymbol.typeKind() == TypeDescKind.UNION) {
            ((UnionTypeSymbol)typeSymbol).memberTypeDescriptors().stream().map(memberTypeSymbol -> this.getRawType((TypeSymbol)memberTypeSymbol, context)).forEach(memberTypeSymbol -> {
                if (memberTypeSymbol.typeKind() == TypeDescKind.UNION) {
                    unionTypes.add(this.getTypeName((TypeSymbol)memberTypeSymbol, context, importsAcceptor));
                    possibleTypes.addAll(((UnionTypeSymbol)memberTypeSymbol).memberTypeDescriptors().stream().map(memberTSymbol -> this.getRawType((TypeSymbol)memberTSymbol, context)).map(symbol -> this.getTypeName((TypeSymbol)symbol, context, importsAcceptor)).toList());
                } else if (memberTypeSymbol.typeKind() == TypeDescKind.ERROR || CommonUtil.getRawType(memberTypeSymbol).typeKind() == TypeDescKind.ERROR) {
                    errorTypes.add(memberTypeSymbol);
                } else {
                    possibleTypes.add(this.getTypeName((TypeSymbol)memberTypeSymbol, context, importsAcceptor));
                }
            });
            if (unionTypes.isEmpty()) {
                unionType = this.getTypeName(typeSymbol, context, importsAcceptor);
            }
        } else {
            String type2 = this.getTypeName(typeSymbol, context, importsAcceptor);
            if (!"any".equals(type2)) {
                return Collections.singletonList(type2);
            }
        }
        LinkedHashSet typesSet = new LinkedHashSet(unionTypes);
        typesSet.addAll(possibleTypes);
        Stream<String> typeStream = typesSet.stream().filter(type -> !"any".equals(type));
        if (!errorTypes.isEmpty()) {
            String errorTypeStr = errorTypes.stream().map(type -> this.getTypeName((TypeSymbol)type, context, importsAcceptor)).collect(Collectors.joining("|"));
            typeStream = typeStream.map(type -> type + "|" + errorTypeStr);
        }
        return Stream.concat(Stream.ofNullable(unionType), typeStream).toList();
    }

    private boolean isInRemoteMethodCallOrResourceAccess(CodeActionContext context) {
        Node evalNode = context.nodeAtRange();
        int count = 0;
        while (evalNode.kind() != SyntaxKind.CLIENT_RESOURCE_ACCESS_ACTION && evalNode.kind() != SyntaxKind.REMOTE_METHOD_CALL_ACTION) {
            if (++count == 3) {
                return false;
            }
            evalNode = evalNode.parent();
        }
        return true;
    }

    private boolean isInActionStatement(NonTerminalNode actionNode) {
        if (actionNode.parent().kind() == SyntaxKind.CHECK_ACTION || actionNode.parent().kind() == SyntaxKind.CHECK_EXPRESSION) {
            actionNode = actionNode.parent();
        }
        return actionNode.parent().kind() == SyntaxKind.ACTION_STATEMENT;
    }

    private String getTypeName(TypeSymbol symbol, CodeActionContext context, ImportsAcceptor importsAcceptor) {
        Optional module = symbol.getModule();
        if (module.isPresent()) {
            Object fqPrefix = "";
            ModuleID id = ((ModuleSymbol)module.get()).id();
            if (!"$anon".equals(id.orgName()) && !this.isLangAnnotationModule(id)) {
                fqPrefix = id.orgName() + "/" + id.moduleName() + ":" + id.version() + ":";
            }
            String moduleQualifiedName = (String)fqPrefix + (symbol.getName().isPresent() ? (String)symbol.getName().get() : this.getRawType(symbol, context).signature());
            return FunctionGenerator.processModuleIDsInText(importsAcceptor, moduleQualifiedName, (DocumentServiceContext)context);
        }
        return FunctionGenerator.processModuleIDsInText(importsAcceptor, symbol.signature(), (DocumentServiceContext)context);
    }

    private boolean isLangAnnotationModule(ModuleID moduleID) {
        return moduleID.orgName().equals("ballerina") && moduleID.moduleName().equals("lang.annotations");
    }

    private TypeSymbol getRawType(TypeSymbol typeSymbol, CodeActionContext context) {
        TypeSymbol rawType = CommonUtil.getRawType(typeSymbol);
        Types types = ((SemanticModel)context.currentSemanticModel().get()).types();
        if (rawType.subtypeOf(types.ERROR) || this.subTypeOfRecord(types, rawType)) {
            return typeSymbol;
        }
        return rawType;
    }

    private boolean subTypeOfRecord(Types types, TypeSymbol rawType) {
        RecordTypeSymbol recordTypeSymbol = types.builder().RECORD_TYPE.withRestField(types.ANY).build();
        return rawType.typeKind() != TypeDescKind.UNION && rawType.subtypeOf((TypeSymbol)recordTypeSymbol);
    }

    private Optional<NonTerminalNode> getActionNode(CodeActionContext context) {
        ActionNodeFinder actionNodeFinder = new ActionNodeFinder();
        return actionNodeFinder.findActionNode(context.nodeAtRange());
    }

    private Optional<TypeSymbol> getReturnTypeOfAction(NonTerminalNode actionNode, CodeActionContext context) {
        Optional semanticModel = context.currentSemanticModel();
        if (semanticModel.isEmpty()) {
            return Optional.empty();
        }
        Optional symbol = semanticModel.flatMap(model -> model.symbol((Node)actionNode));
        if (symbol.isEmpty()) {
            return Optional.empty();
        }
        Optional returnTypeDesc = Optional.empty();
        if (((Symbol)symbol.get()).kind() == SymbolKind.METHOD) {
            returnTypeDesc = ((MethodSymbol)symbol.get()).typeDescriptor().returnTypeDescriptor();
        } else if (((Symbol)symbol.get()).kind() == SymbolKind.RESOURCE_METHOD) {
            returnTypeDesc = ((ResourceMethodSymbol)symbol.get()).typeDescriptor().returnTypeDescriptor();
        }
        if (returnTypeDesc.isEmpty()) {
            return Optional.empty();
        }
        NonTerminalNode parent = actionNode.parent();
        if (parent.kind() != SyntaxKind.CHECK_EXPRESSION && parent.kind() != SyntaxKind.CHECK_ACTION || ((TypeSymbol)returnTypeDesc.get()).typeKind() != TypeDescKind.UNION) {
            return returnTypeDesc;
        }
        List<TypeSymbol> memberTypes = ((UnionTypeSymbol)returnTypeDesc.get()).memberTypeDescriptors().stream().filter(member -> CommonUtil.getRawType(member).typeKind() != TypeDescKind.ERROR).toList();
        if (memberTypes.isEmpty()) {
            return Optional.empty();
        }
        if (memberTypes.size() == 1) {
            return Optional.of(memberTypes.get(0));
        }
        UnionTypeSymbol unionTypeSymbol = ((SemanticModel)semanticModel.get()).types().builder().UNION_TYPE.withMemberTypes(memberTypes.toArray(new TypeSymbol[0])).build();
        return Optional.of(unionTypeSymbol);
    }

    @Override
    public String getName() {
        return NAME;
    }

    static class ActionNodeFinder
    extends NodeVisitor {
        private NonTerminalNode actionNode = null;

        ActionNodeFinder() {
        }

        public Optional<NonTerminalNode> findActionNode(Node node) {
            if (node.kind() == SyntaxKind.LIST) {
                node.parent().accept((NodeVisitor)this);
            }
            node.accept((NodeVisitor)this);
            return Optional.ofNullable(this.actionNode);
        }

        public void visit(SimpleNameReferenceNode simpleNameReferenceNode) {
            simpleNameReferenceNode.parent().accept((NodeVisitor)this);
        }

        public void visit(NamedArgumentNode namedArgumentNode) {
            namedArgumentNode.parent().accept((NodeVisitor)this);
        }

        public void visit(RemoteMethodCallActionNode remoteMethodCallActionNode) {
            this.actionNode = remoteMethodCallActionNode;
        }

        public void visit(ClientResourceAccessActionNode clientResourceAccessActionNode) {
            this.actionNode = clientResourceAccessActionNode;
        }

        protected void visitSyntaxNode(Node node) {
            NonTerminalNode parent = node.parent();
            if (parent == null) {
                return;
            }
            node.parent().accept((NodeVisitor)this);
        }
    }
}

