/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers.imports;

import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.LSPackageLoader;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.ModuleUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagnosticBasedCodeActionProvider;
import org.ballerinalang.model.Name;
import org.ballerinalang.util.diagnostic.DiagnosticErrorCode;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;
import org.wso2.ballerinalang.compiler.tree.BLangIdentifier;

public class ImportModuleCodeAction
implements DiagnosticBasedCodeActionProvider {
    public static final String NAME = "Import Module";

    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return DiagnosticErrorCode.UNDEFINED_MODULE.diagnosticId().equals(diagnostic.diagnosticInfo().code()) && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        String uri = context.fileUri();
        if (context.currentSyntaxTree().isEmpty()) {
            return Collections.emptyList();
        }
        Range diagRange = PositionUtil.toRange(diagnostic.location().lineRange());
        NonTerminalNode node = CommonUtil.findNode(diagRange, (SyntaxTree)context.currentSyntaxTree().get());
        QNameRefFinder finder = new QNameRefFinder(((DiagnosticProperty)diagnostic.properties().get(0)).value());
        node.accept((NodeVisitor)finder);
        Optional<QualifiedNameReferenceNode> qNameReferenceNode = finder.getQNameReferenceNode();
        if (qNameReferenceNode.isEmpty()) {
            return Collections.emptyList();
        }
        String modulePrefix = qNameReferenceNode.get().modulePrefix().text();
        List<LSPackageLoader.ModuleInfo> moduleList = LSPackageLoader.getInstance(context.languageServercontext()).getAllVisiblePackages((DocumentServiceContext)context);
        Map<ImportDeclarationNode, ModuleSymbol> symbolMap = context.currentDocImportsMap().entrySet().stream().filter(entry -> modulePrefix.equals(((IdentifierToken)((ImportDeclarationNode)entry.getKey()).moduleName().get(((ImportDeclarationNode)entry.getKey()).moduleName().size() - 1)).text())).filter(entry -> ((ImportDeclarationNode)entry.getKey()).prefix().isPresent()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        List<ModuleSymbol> existingModules = symbolMap.values().stream().filter(moduleSymbol -> moduleSymbol.getModule().isPresent()).map(moduleSymbol -> (ModuleSymbol)moduleSymbol.getModule().get()).toList();
        ArrayList<CodeAction> actions = new ArrayList<CodeAction>();
        symbolMap.forEach((importNode, moduleSymbol) -> {
            if (importNode.prefix().isEmpty()) {
                return;
            }
            ImportPrefixNode prefixNode = (ImportPrefixNode)importNode.prefix().get();
            Token prefix = prefixNode.prefix();
            if (prefix.kind() == SyntaxKind.UNDERSCORE_KEYWORD) {
                int startOffset = ((IdentifierToken)importNode.moduleName().get(importNode.moduleName().size() - 1)).textRange().endOffset();
                Range insertRange = PositionUtil.toRange(startOffset, prefixNode.textRange().endOffset(), ((SyntaxTree)context.currentSyntaxTree().get()).textDocument());
                List<TextEdit> edits = Collections.singletonList(new TextEdit(insertRange, ""));
                CodeAction codeAction = CodeActionUtil.createCodeAction("Remove module alias", edits, uri, "quickfix");
                actions.add(codeAction);
            } else {
                String modPrefix = moduleSymbol.id().modulePrefix();
                Range insertRange = PositionUtil.toRange(((QualifiedNameReferenceNode)qNameReferenceNode.get()).modulePrefix().lineRange());
                List<TextEdit> edits = Collections.singletonList(new TextEdit(insertRange, modPrefix));
                CodeAction codeAction = CodeActionUtil.createCodeAction(String.format("Change module prefix to '%s'", modPrefix), edits, uri, "quickfix");
                actions.add(codeAction);
            }
        });
        moduleList.stream().filter(pkgEntry -> existingModules.stream().noneMatch(moduleSymbol -> moduleSymbol.id().orgName().equals(pkgEntry.packageOrg()) && moduleSymbol.id().moduleName().equals(pkgEntry.packageName()))).filter(pkgEntry -> {
            String pkgName = pkgEntry.packageName();
            return pkgName.endsWith("." + modulePrefix) || pkgName.equals(modulePrefix);
        }).forEach(pkgEntry -> {
            String orgName = pkgEntry.packageOrg();
            String pkgName = pkgEntry.packageName();
            String moduleName = ModuleUtil.escapeModuleName(pkgName);
            Position insertPos = CommonUtil.getImportPosition((DocumentServiceContext)context);
            String importText = orgName.isEmpty() ? String.format("%s %s;%n", "import", moduleName) : String.format("%s %s/%s;%n", "import", orgName, moduleName);
            String commandTitle = orgName.isEmpty() ? String.format("Import module '%s'", moduleName) : String.format("Import module '%s'", orgName + "/" + moduleName);
            List<TextEdit> edits = Collections.singletonList(new TextEdit(new Range(insertPos, insertPos), importText));
            CodeAction action = CodeActionUtil.createCodeAction(commandTitle, edits, uri, "quickfix");
            actions.add(action);
        });
        return actions;
    }

    public String getName() {
        return NAME;
    }

    static class QNameRefFinder
    extends NodeVisitor {
        private final String moduleName;
        private QualifiedNameReferenceNode qualifiedNameReferenceNode;

        public QNameRefFinder(Object nameObj) {
            if (nameObj instanceof Name) {
                Name name = (Name)nameObj;
                this.moduleName = name.getValue();
            } else if (nameObj instanceof BLangIdentifier) {
                BLangIdentifier identifier = (BLangIdentifier)nameObj;
                this.moduleName = identifier.getValue();
            } else {
                this.moduleName = nameObj.toString();
            }
        }

        public void visit(QualifiedNameReferenceNode qualifiedNameReferenceNode) {
            if (qualifiedNameReferenceNode.modulePrefix().text().equals(this.moduleName)) {
                this.qualifiedNameReferenceNode = qualifiedNameReferenceNode;
            }
        }

        Optional<QualifiedNameReferenceNode> getQNameReferenceNode() {
            return Optional.ofNullable(this.qualifiedNameReferenceNode);
        }
    }
}

