/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codeaction.providers.imports;

import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.Document;
import io.ballerina.tools.diagnostics.Diagnostic;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.codeaction.CodeActionNodeValidator;
import org.ballerinalang.langserver.codeaction.CodeActionUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagBasedPositionDetails;
import org.ballerinalang.langserver.commons.codeaction.spi.DiagnosticBasedCodeActionProvider;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class RemoveImportCodeAction
implements DiagnosticBasedCodeActionProvider {
    public static final String NAME = "remove import";
    public static final Set<String> DIAGNOSTIC_CODES = Set.of("BCE2002", "BCE2004", "BCE2008");

    public boolean validate(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        return DIAGNOSTIC_CODES.contains(diagnostic.diagnosticInfo().code()) && CodeActionNodeValidator.validate(context.nodeAtRange());
    }

    public List<CodeAction> getCodeActions(Diagnostic diagnostic, DiagBasedPositionDetails positionDetails, CodeActionContext context) {
        Optional<ImportDeclarationNode> importDeclarationNode = this.getImportDeclarationNode(positionDetails.matchedNode());
        if (importDeclarationNode.isEmpty() || context.currentDocument().isEmpty()) {
            return Collections.emptyList();
        }
        ImportDeclarationNode importDeclNode = importDeclarationNode.get();
        Range range = PositionUtil.toRange(importDeclNode.textRange().startOffset(), importDeclNode.textRangeWithMinutiae().endOffset(), ((Document)context.currentDocument().get()).textDocument());
        List<TextEdit> edits = List.of(new TextEdit(range, ""));
        String pkgName = this.getPackageName(importDeclNode);
        String commandTitle = "BCE2002".equals(diagnostic.diagnosticInfo().code()) ? String.format("Remove unused import '%s'", pkgName) : String.format("Remove re-declared import '%s'", pkgName);
        return List.of(CodeActionUtil.createCodeAction(commandTitle, edits, context.fileUri(), "quickfix"));
    }

    private String getPackageName(ImportDeclarationNode importDeclNode) {
        if (importDeclNode.prefix().isPresent()) {
            return ((ImportPrefixNode)importDeclNode.prefix().get()).prefix().text();
        }
        return (importDeclNode.orgName().isPresent() ? ((ImportOrgNameNode)importDeclNode.orgName().get()).toString() : "") + importDeclNode.moduleName().stream().map(Node::toString).collect(Collectors.joining("."));
    }

    private Optional<ImportDeclarationNode> getImportDeclarationNode(NonTerminalNode node) {
        while (node != null) {
            if (node.kind() == SyntaxKind.IMPORT_DECLARATION) {
                return Optional.of((ImportDeclarationNode)node);
            }
            node = node.parent();
        }
        return Optional.empty();
    }

    public String getName() {
        return NAME;
    }
}

