/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.codelenses.providers;

import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.codelenses.providers.AbstractCodeLensesProvider;
import org.ballerinalang.langserver.command.docs.DocumentationGenerator;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.LanguageServerContext;
import org.ballerinalang.langserver.commons.command.CommandArgument;
import org.ballerinalang.langserver.config.LSClientConfigHolder;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Range;

public class DocsCodeLensesProvider
extends AbstractCodeLensesProvider {
    public DocsCodeLensesProvider() {
        super("docs.CodeLenses");
    }

    @Override
    public boolean isEnabled(LanguageServerContext serverContext) {
        return LSClientConfigHolder.getInstance(serverContext).getConfig().getCodeLens().getDocs().isEnabled();
    }

    public List<CodeLens> getLenses(DocumentServiceContext context) {
        ArrayList<CodeLens> lenses = new ArrayList<CodeLens>();
        Optional syntaxTree = context.currentSyntaxTree();
        if (syntaxTree.isEmpty()) {
            return lenses;
        }
        for (ModuleMemberDeclarationNode member : ((ModulePartNode)((SyntaxTree)syntaxTree.get()).rootNode()).members()) {
            if (DocumentationGenerator.hasDocs((NonTerminalNode)member)) continue;
            Range nodeRange = null;
            boolean showLens = false;
            switch (member.kind()) {
                case FUNCTION_DEFINITION: {
                    FunctionDefinitionNode funcDef = (FunctionDefinitionNode)member;
                    String nodeName = funcDef.functionName().text();
                    for (Token qualifier : funcDef.qualifierList()) {
                        if (qualifier.kind() != SyntaxKind.PUBLIC_KEYWORD || "main".equals(nodeName)) continue;
                        showLens = true;
                        break;
                    }
                    nodeRange = PositionUtil.toRange(funcDef.lineRange());
                    break;
                }
                case TYPE_DEFINITION: {
                    TypeDefinitionNode typeDef = (TypeDefinitionNode)member;
                    showLens = typeDef.visibilityQualifier().map(s -> s.kind() == SyntaxKind.PUBLIC_KEYWORD).orElse(false);
                    nodeRange = PositionUtil.toRange(typeDef.lineRange());
                    break;
                }
                case CLASS_DEFINITION: {
                    ClassDefinitionNode classDef = (ClassDefinitionNode)member;
                    showLens = classDef.visibilityQualifier().map(s -> s.kind() == SyntaxKind.PUBLIC_KEYWORD).orElse(false);
                    nodeRange = PositionUtil.toRange(classDef.lineRange());
                    break;
                }
            }
            if (!showLens) continue;
            String documentUri = context.fileUri();
            CommandArgument docUriArg = CommandArgument.from((String)"doc.uri", (Object)documentUri);
            CommandArgument lineStart = CommandArgument.from((String)"node.range", nodeRange);
            ArrayList<CommandArgument> args = new ArrayList<CommandArgument>(Arrays.asList(docUriArg, lineStart));
            Command command = new Command("Document this", "ADD_DOC", args);
            lenses.add(new CodeLens(nodeRange, command, null));
        }
        return lenses;
    }
}

