/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.command.executors;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Documentable;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Optional;
import org.ballerinalang.langserver.command.CommandUtil;
import org.ballerinalang.langserver.command.docs.DocAttachmentInfo;
import org.ballerinalang.langserver.command.docs.DocumentationGenerator;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.PathUtil;
import org.ballerinalang.langserver.commons.ExecuteCommandContext;
import org.ballerinalang.langserver.commons.client.ExtendedLanguageClient;
import org.ballerinalang.langserver.commons.command.CommandArgument;
import org.ballerinalang.langserver.commons.command.spi.LSCommandExecutor;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.VersionedTextDocumentIdentifier;
import org.eclipse.lsp4j.services.LanguageClient;

public abstract class AbstractDocumentationExecutor
implements LSCommandExecutor {
    public Object execute(ExecuteCommandContext ctx) {
        Range range;
        Optional documentation;
        Optional<DocAttachmentInfo> docAttachmentInfo;
        String documentUri = "";
        Range nodeRange = null;
        VersionedTextDocumentIdentifier textDocumentIdentifier = new VersionedTextDocumentIdentifier();
        for (CommandArgument arg : ctx.getArguments()) {
            String argKey;
            switch (argKey = arg.key()) {
                case "doc.uri": {
                    documentUri = (String)arg.valueAs(String.class);
                    textDocumentIdentifier.setUri(documentUri);
                    break;
                }
                case "node.range": {
                    nodeRange = (Range)arg.valueAs(Range.class);
                    break;
                }
            }
        }
        Optional<Path> filePath = PathUtil.getPathFromURI(documentUri);
        if (filePath.isEmpty() || nodeRange == null) {
            return Collections.emptyList();
        }
        SyntaxTree syntaxTree = (SyntaxTree)ctx.workspace().syntaxTree(filePath.get()).orElseThrow();
        NonTerminalNode node = CommonUtil.findNode(nodeRange, syntaxTree);
        if (node.kind() == SyntaxKind.MODULE_PART) {
            node = (NonTerminalNode)((ModulePartNode)node).members().get(0);
        }
        if ((docAttachmentInfo = DocumentationGenerator.getDocumentationEditForNode(node, syntaxTree)).isEmpty()) {
            return Collections.emptyList();
        }
        SemanticModel semanticModel = (SemanticModel)ctx.workspace().semanticModel(filePath.get()).orElseThrow();
        Optional<Symbol> documentableSymbol = DocumentationGenerator.getDocumentableSymbol(node, semanticModel);
        boolean isUpdate = false;
        DocAttachmentInfo docs = docAttachmentInfo.get();
        Optional<Range> docsRange = DocumentationGenerator.getDocsRange(node);
        if (documentableSymbol.isPresent() && (documentation = ((Documentable)documentableSymbol.get()).documentation()).isPresent()) {
            docs = docs.mergeDocAttachment((Documentation)documentation.get());
        }
        if (docsRange.isPresent()) {
            isUpdate = true;
            range = docsRange.get();
        } else {
            range = new Range(docs.getDocStartPos(), docs.getDocStartPos());
        }
        ExtendedLanguageClient lsClient = ctx.getLanguageClient();
        return CommandUtil.applySingleTextEdit(docs.getDocumentationString(!isUpdate), range, textDocumentIdentifier, (LanguageClient)lsClient);
    }
}

