/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.common;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.Document;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.CodeActionContext;

public final class ConfigurableFinder {
    private ConfigurableFinder() {
    }

    public static ModuleConfigDetails getModuleConfigDetails(CodeActionContext context) {
        SemanticModel semanticModel = (SemanticModel)context.currentSemanticModel().get();
        Module module = (Module)context.currentModule().get();
        HashMap<String, ConfigVariable> configVariables = new HashMap<String, ConfigVariable>();
        int index = 0;
        for (DocumentId documentId : module.documentIds()) {
            Document document = module.document(documentId);
            ModulePartNode modulePartNode = (ModulePartNode)document.syntaxTree().rootNode();
            for (NonTerminalNode member : modulePartNode.members()) {
                Optional symbol;
                ModuleVariableDeclarationNode moduleVar;
                if (member.kind() != SyntaxKind.MODULE_VAR_DECL || !ConfigurableFinder.hasConfigurableQualifier(moduleVar = (ModuleVariableDeclarationNode)member) || (symbol = semanticModel.symbol((Node)moduleVar)).isEmpty()) continue;
                VariableSymbol variableSymbol = (VariableSymbol)symbol.get();
                TypeSymbol type = CommonUtil.getRawType(variableSymbol.typeDescriptor());
                boolean isRequiredVariable = moduleVar.initializer().stream().anyMatch(var -> var.kind() == SyntaxKind.REQUIRED_EXPRESSION);
                String varName = (String)variableSymbol.getName().get();
                ConfigVariable configVariable = new ConfigVariable(varName, type, isRequiredVariable, index++);
                configVariables.put(varName, configVariable);
            }
        }
        String moduleName = module.isDefaultModule() ? "" : module.moduleName().moduleNamePart();
        return new ModuleConfigDetails(moduleName, module.isDefaultModule(), configVariables);
    }

    private static boolean hasConfigurableQualifier(ModuleVariableDeclarationNode node) {
        return node.qualifiers().stream().anyMatch(q -> q.text().equals(Qualifier.CONFIGURABLE.getValue()));
    }

    public record ConfigVariable(String name, TypeSymbol type, boolean isRequired, int index) implements Comparable<ConfigVariable>
    {
        @Override
        public int compareTo(ConfigVariable o) {
            return this.index() - o.index();
        }
    }

    public record ModuleConfigDetails(String moduleName, boolean isDefaultModule, Map<String, ConfigVariable> configVariables) {
    }
}

