/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.common;

import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.projects.Project;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.codeaction.CodeActionModuleId;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.ModuleUtil;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public class ImportsAcceptor {
    private final Set<String> newImports = new HashSet<String>();
    private final Map<ImportDeclarationNode, ModuleSymbol> currentModuleImportsMap;
    private final BiConsumer<String, CodeActionModuleId> onExistCallback;

    public ImportsAcceptor(DocumentServiceContext context) {
        this(context, null);
    }

    public ImportsAcceptor(DocumentServiceContext context, BiConsumer<String, CodeActionModuleId> onExistCallback) {
        this.currentModuleImportsMap = context.currentDocImportsMap();
        this.onExistCallback = onExistCallback;
    }

    public BiConsumer<String, CodeActionModuleId> getAcceptor(DocumentServiceContext context) {
        Optional project = context.workspace().project(context.filePath());
        String currentPkgName = CommonUtil.escapeReservedKeyword(((Project)project.get()).currentPackage().packageName().value());
        String currentOrgName = CommonUtil.escapeReservedKeyword(((Project)project.get()).currentPackage().packageOrg().value());
        return (orgName, codeActionModuleId) -> {
            boolean notFound = this.currentModuleImportsMap.keySet().stream().noneMatch(pkg -> {
                String importAlias = pkg.moduleName().stream().map(identifierToken -> CommonUtil.escapeReservedKeyword(identifierToken.text())).collect(Collectors.joining("."));
                boolean isCurrentPkgModule = pkg.orgName().isEmpty() && importAlias.startsWith(currentPkgName + ".");
                boolean aliasMatched = importAlias.equals(codeActionModuleId.moduleName());
                return (isCurrentPkgModule || ((ImportOrgNameNode)pkg.orgName().get()).orgName().text().equals(orgName)) && aliasMatched;
            });
            if (notFound) {
                Object moduleName = codeActionModuleId.moduleName();
                String modulePrefix = ModuleUtil.escapeModuleName((String)moduleName).replaceAll(".*\\.", "");
                if (!codeActionModuleId.modulePrefix().isEmpty() && !modulePrefix.equals(codeActionModuleId.modulePrefix())) {
                    moduleName = codeActionModuleId.moduleName() + " as " + codeActionModuleId.modulePrefix();
                }
                String pkgName = orgName.isEmpty() || orgName.equals(currentOrgName) ? moduleName : orgName + "/" + (String)moduleName;
                this.newImports.add(pkgName);
                if (this.onExistCallback != null) {
                    this.onExistCallback.accept((String)orgName, (CodeActionModuleId)codeActionModuleId);
                }
            }
        };
    }

    public List<TextEdit> getNewImportTextEdits() {
        ArrayList<TextEdit> edits = new ArrayList<TextEdit>();
        this.newImports.forEach(i -> edits.add(this.createImportTextEdit((String)i)));
        return edits;
    }

    public Set<String> getNewImports() {
        return this.newImports;
    }

    private TextEdit createImportTextEdit(String pkgName) {
        Optional<ImportDeclarationNode> lastImport = CommonUtil.getLastItem(new ArrayList<ImportDeclarationNode>(this.currentModuleImportsMap.keySet()));
        int endCol = 0;
        int endLine = lastImport.isEmpty() ? 0 : lastImport.get().location().lineRange().endLine().line();
        String editText = String.format("%s %s;%n", "import", pkgName);
        Range range = new Range(new Position(endLine, endCol), new Position(endLine, endCol));
        return new TextEdit(range, editText);
    }
}

