/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.common;

import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import java.util.Objects;
import org.ballerinalang.langserver.common.utils.RawTypeSymbolWrapper;

public class RecordField {
    String name;
    RecordFieldSymbol fieldSymbol;
    RawTypeSymbolWrapper<RecordTypeSymbol> typeSymbolWrapper;

    public RecordField(String name, RecordFieldSymbol fieldSymbol, RawTypeSymbolWrapper<RecordTypeSymbol> typeSymbolWrapper) {
        this.name = name;
        this.fieldSymbol = fieldSymbol;
        this.typeSymbolWrapper = typeSymbolWrapper;
    }

    public RawTypeSymbolWrapper<RecordTypeSymbol> getTypeSymbolWrapper() {
        return this.typeSymbolWrapper;
    }

    public String getName() {
        return this.name;
    }

    public RecordFieldSymbol getFieldSymbol() {
        return this.fieldSymbol;
    }

    public static class RecordFieldIdentifier {
        private final String name;
        private final TypeSymbol typeSymbol;

        public RecordFieldIdentifier(String name, TypeSymbol typeSymbol) {
            this.name = name;
            this.typeSymbol = typeSymbol;
        }

        public int hashCode() {
            return Objects.hash(this.name, this.typeSymbol.signature());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RecordFieldIdentifier)) {
                return false;
            }
            RecordFieldIdentifier other = (RecordFieldIdentifier)obj;
            return other.name.equals(this.name) && other.typeSymbol.signature().equals(this.typeSymbol.signature());
        }

        public String getName() {
            return this.name;
        }
    }
}

