/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.common.utils;

import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.ErrorTypeSymbol;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TupleTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.RecordUtil;
import org.ballerinalang.langserver.commons.SnippetContext;

public final class DefaultValueGenerationUtil {
    private DefaultValueGenerationUtil() {
    }

    public static Optional<String> getDefaultValueForType(TypeSymbol bType, SnippetContext snippetContext) {
        return DefaultValueGenerationUtil.getDefaultValueForType(bType, true, snippetContext);
    }

    public static Optional<String> getDefaultPlaceholderForType(TypeSymbol bType) {
        return DefaultValueGenerationUtil.getDefaultValueForType(bType).map(defaultValue -> defaultValue.replace("}", "\\}"));
    }

    public static Optional<String> getDefaultValueForType(TypeSymbol bType) {
        return DefaultValueGenerationUtil.getDefaultValueForType(bType, false, new SnippetContext());
    }

    public static Optional<String> getDefaultValueForTypeDescKind(TypeDescKind typeKind) {
        String defaultValue = null;
        switch (typeKind) {
            case FLOAT: {
                defaultValue = Float.toString(0.0f);
                break;
            }
            case BOOLEAN: {
                defaultValue = Boolean.toString(false);
                break;
            }
            case RECORD: 
            case MAP: {
                defaultValue = "{}";
                break;
            }
            case STREAM: {
                defaultValue = "new ()";
                break;
            }
            case XML: {
                defaultValue = "xml ``";
                break;
            }
            case DECIMAL: {
                defaultValue = Integer.toString(0);
                break;
            }
            case ARRAY: {
                defaultValue = "[]";
                break;
            }
            case SINGLETON: {
                defaultValue = "\"\"";
                break;
            }
            case ERROR: {
                defaultValue = "error(\"\")";
                break;
            }
            case REGEXP: {
                defaultValue = "re ``";
                break;
            }
            default: {
                if (typeKind.isIntegerType()) {
                    defaultValue = Integer.toString(0);
                    break;
                }
                if (!typeKind.isStringType()) break;
                defaultValue = "\"\"";
            }
        }
        return Optional.ofNullable(defaultValue);
    }

    public static Optional<String> getDefaultValueForTypeDescKind(TypeSymbol typeSymbol) {
        TypeDescKind typeKind = typeSymbol.typeKind();
        String defaultValue = switch (typeKind) {
            case TypeDescKind.SINGLETON -> typeSymbol.signature();
            case TypeDescKind.TYPE_REFERENCE -> DefaultValueGenerationUtil.getDefaultValueForTypeDescKind(CommonUtil.getRawType(typeSymbol)).orElse(null);
            default -> DefaultValueGenerationUtil.getDefaultValueForTypeDescKind(typeKind).orElse(null);
        };
        return Optional.ofNullable(defaultValue);
    }

    private static String generateSnippetEntry(String value, int offset) {
        return "${" + offset + ":" + value + "}";
    }

    private static Optional<String> getDefaultValueForType(TypeSymbol bType, boolean isSnippet, SnippetContext context) {
        Object valueString;
        if (bType == null) {
            return Optional.empty();
        }
        TypeSymbol rawType = CommonUtil.getRawType(bType);
        TypeDescKind typeKind = rawType.typeKind();
        switch (typeKind) {
            case TUPLE: {
                TupleTypeSymbol tupleType = (TupleTypeSymbol)rawType;
                List<String> memberDefaultValues = tupleType.memberTypeDescriptors().stream().map(member -> DefaultValueGenerationUtil.getDefaultValueForTypeDescKind(member).orElse("")).toList();
                if (memberDefaultValues.isEmpty()) {
                    valueString = isSnippet ? "[${" + context.incrementAndGetPlaceholderCount() + "}]" : "[]";
                    break;
                }
                ArrayList<String> memberSnippets = new ArrayList<String>();
                for (String value : memberDefaultValues) {
                    memberSnippets.add(isSnippet ? DefaultValueGenerationUtil.generateSnippetEntry(value, context.incrementAndGetPlaceholderCount()) : value);
                }
                valueString = "[" + String.join((CharSequence)", ", memberSnippets) + "]";
                context.incrementAndGetPlaceholderCount();
                break;
            }
            case ARRAY: {
                ArrayTypeSymbol arrayType = (ArrayTypeSymbol)rawType;
                if (arrayType.memberTypeDescriptor().typeKind() == TypeDescKind.ARRAY) {
                    String value = DefaultValueGenerationUtil.getDefaultValueForTypeDescKind(arrayType.memberTypeDescriptor()).orElse("");
                    valueString = "[" + (isSnippet ? DefaultValueGenerationUtil.generateSnippetEntry(value, context.incrementAndGetPlaceholderCount()) : value) + "]";
                    break;
                }
                valueString = isSnippet ? "[${" + context.incrementAndGetPlaceholderCount() + "}]" : "[]";
                break;
            }
            case RECORD: {
                RecordTypeSymbol recordTypeSymbol = (RecordTypeSymbol)rawType;
                ArrayList<CallSite> fieldInsertText = new ArrayList<CallSite>();
                valueString = "{";
                List<RecordFieldSymbol> mandatoryFieldSymbols = RecordUtil.getMandatoryRecordFields(recordTypeSymbol).stream().filter(recordFieldSymbol -> recordFieldSymbol.getName().isPresent()).toList();
                for (RecordFieldSymbol mandatoryField : mandatoryFieldSymbols) {
                    String value = DefaultValueGenerationUtil.getDefaultValueForTypeDescKind(CommonUtil.getRawType(mandatoryField.typeDescriptor())).orElse("");
                    String fieldName = CommonUtil.escapeReservedKeyword((String)mandatoryField.getName().get());
                    fieldInsertText.add((CallSite)((Object)(fieldName + ": " + (isSnippet ? DefaultValueGenerationUtil.generateSnippetEntry(value, context.incrementAndGetPlaceholderCount()) : value))));
                }
                valueString = (String)valueString + String.join((CharSequence)", ", fieldInsertText);
                valueString = (String)valueString + "}";
                break;
            }
            case OBJECT: {
                ObjectTypeSymbol objectTypeSymbol = (ObjectTypeSymbol)rawType;
                if (objectTypeSymbol.kind() == SymbolKind.CLASS) {
                    ClassSymbol classSymbol = (ClassSymbol)objectTypeSymbol;
                    if (classSymbol.initMethod().isPresent()) {
                        List params = (List)((MethodSymbol)classSymbol.initMethod().get()).typeDescriptor().params().get();
                        ArrayList<String> paramSnippets = new ArrayList<String>();
                        for (ParameterSymbol param : params) {
                            String value = DefaultValueGenerationUtil.getDefaultValueForTypeDescKind(CommonUtil.getRawType(param.typeDescriptor())).orElse("");
                            paramSnippets.add(isSnippet ? DefaultValueGenerationUtil.generateSnippetEntry(value, context.incrementAndGetPlaceholderCount()) : value);
                        }
                        valueString = "new (" + String.join((CharSequence)", ", paramSnippets) + ")";
                        break;
                    }
                    valueString = isSnippet ? "${" + context.incrementAndGetPlaceholderCount() + ":new ()}" : "new ()";
                    break;
                }
                valueString = isSnippet ? "${" + context.incrementAndGetPlaceholderCount() + ":object {}}" : "object {}";
                break;
            }
            case UNION: {
                ArrayList members = new ArrayList(((UnionTypeSymbol)rawType).memberTypeDescriptors());
                List<TypeSymbol> nilMembers = members.stream().filter(member -> member.typeKind() == TypeDescKind.NIL).toList();
                if (nilMembers.isEmpty()) {
                    valueString = DefaultValueGenerationUtil.getDefaultValueForTypeDescKind(CommonUtil.getRawType((TypeSymbol)members.get(0))).orElse("");
                    valueString = isSnippet ? DefaultValueGenerationUtil.generateSnippetEntry((String)valueString, context.incrementAndGetPlaceholderCount()) : valueString;
                    break;
                }
                valueString = isSnippet ? DefaultValueGenerationUtil.generateSnippetEntry("()", context.incrementAndGetPlaceholderCount()) : "()";
                break;
            }
            case INTERSECTION: {
                TypeSymbol effectiveType = ((IntersectionTypeSymbol)rawType).effectiveTypeDescriptor();
                effectiveType = CommonUtil.getRawType(effectiveType);
                if (effectiveType.typeKind() == TypeDescKind.INTERSECTION) {
                    valueString = isSnippet ? DefaultValueGenerationUtil.generateSnippetEntry("()", context.incrementAndGetPlaceholderCount()) : "()";
                    Optional<TypeSymbol> memberType = ((IntersectionTypeSymbol)effectiveType).memberTypeDescriptors().stream().filter(typeSymbol -> typeSymbol.typeKind() != TypeDescKind.READONLY).findAny();
                    if (!memberType.isPresent()) break;
                    valueString = DefaultValueGenerationUtil.getDefaultValueForTypeDescKind(CommonUtil.getRawType(memberType.get())).orElse("");
                    valueString = isSnippet ? DefaultValueGenerationUtil.generateSnippetEntry((String)valueString, context.incrementAndGetPlaceholderCount()) : valueString;
                    break;
                }
                valueString = DefaultValueGenerationUtil.getDefaultValueForTypeDescKind(CommonUtil.getRawType(effectiveType)).orElse("");
                valueString = isSnippet ? DefaultValueGenerationUtil.generateSnippetEntry((String)valueString, context.incrementAndGetPlaceholderCount()) : valueString;
                break;
            }
            case TABLE: {
                String rowValue = "";
                valueString = "table [" + (isSnippet ? DefaultValueGenerationUtil.generateSnippetEntry(rowValue, context.incrementAndGetPlaceholderCount()) : rowValue) + "]";
                break;
            }
            case ERROR: {
                List<RecordFieldSymbol> mandatoryFields;
                TypeSymbol errorType = CommonUtil.getRawType(((ErrorTypeSymbol)rawType).detailTypeDescriptor());
                StringBuilder errorString = new StringBuilder("error(\"\"");
                if (errorType.typeKind() == TypeDescKind.RECORD && !(mandatoryFields = RecordUtil.getMandatoryRecordFields((RecordTypeSymbol)errorType)).isEmpty()) {
                    errorString.append(", ");
                    ArrayList<CallSite> detailFieldSnippets = new ArrayList<CallSite>();
                    for (RecordFieldSymbol field : mandatoryFields) {
                        String defValue = DefaultValueGenerationUtil.getDefaultValueForTypeDescKind(CommonUtil.getRawType(field.typeDescriptor())).orElse("");
                        detailFieldSnippets.add((CallSite)((Object)((String)field.getName().get() + " = " + (isSnippet ? DefaultValueGenerationUtil.generateSnippetEntry(defValue, context.incrementAndGetPlaceholderCount()) : defValue))));
                    }
                    errorString.append(String.join((CharSequence)", ", detailFieldSnippets));
                }
                errorString.append(")");
                valueString = errorString.toString();
                break;
            }
            case SINGLETON: {
                valueString = rawType.signature();
                valueString = isSnippet ? DefaultValueGenerationUtil.generateSnippetEntry((String)valueString, context.incrementAndGetPlaceholderCount()) : valueString;
                break;
            }
            case JSON: 
            case NIL: 
            case ANY: {
                valueString = "()";
                valueString = isSnippet ? DefaultValueGenerationUtil.generateSnippetEntry((String)valueString, context.incrementAndGetPlaceholderCount()) : valueString;
                break;
            }
            case TYPE_REFERENCE: {
                return DefaultValueGenerationUtil.getDefaultValueForType(CommonUtil.getRawType(bType), isSnippet, context);
            }
            default: {
                Optional<String> value = DefaultValueGenerationUtil.getDefaultValueForTypeDescKind(typeKind);
                if (value.isEmpty()) {
                    return value;
                }
                valueString = isSnippet ? DefaultValueGenerationUtil.generateSnippetEntry(value.get(), context.incrementAndGetPlaceholderCount()) : value.get();
            }
        }
        return Optional.of(valueString);
    }
}

