/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.common.utils;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.projects.Module;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.ballerinalang.langserver.codeaction.CodeActionModuleId;
import org.ballerinalang.langserver.common.ImportsAcceptor;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.DefaultValueGenerationUtil;
import org.ballerinalang.langserver.common.utils.ModuleUtil;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.ballerinalang.langserver.commons.DocumentServiceContext;

public final class FunctionGenerator {
    public static final Pattern FULLY_QUALIFIED_MODULE_ID_PATTERN = Pattern.compile("([\\w]+)\\/([\\w.]+):([^:]+):([\\w]+)[\\|]?");

    private FunctionGenerator() {
    }

    public static String generateTypeSignature(ImportsAcceptor importsAcceptor, TypeSymbol typeDescriptor, DocumentServiceContext context) {
        return FunctionGenerator.processModuleIDsInText(importsAcceptor, typeDescriptor.signature(), context);
    }

    public static String processModuleIDsInText(ImportsAcceptor importsAcceptor, String text, DocumentServiceContext context) {
        Module module = (Module)context.workspace().module(context.filePath()).orElseThrow();
        String currentOrg = module.packageInstance().descriptor().org().value();
        String currentModule = module.descriptor().name().toString();
        String currentVersion = module.packageInstance().descriptor().version().value().toString();
        StringBuilder newText = new StringBuilder();
        CodeActionModuleId currentModuleID = CodeActionModuleId.from(currentOrg, currentModule, currentVersion);
        Matcher matcher = FULLY_QUALIFIED_MODULE_ID_PATTERN.matcher(text);
        int nextStart = 0;
        while (matcher.find()) {
            newText.append(text, nextStart, matcher.start(1));
            CodeActionModuleId moduleID = CodeActionModuleId.from(matcher.group(1), matcher.group(2), matcher.group(3));
            newText.append(ModuleUtil.getModulePrefix(importsAcceptor, currentModuleID, moduleID, context));
            nextStart = matcher.end(3) + 1;
        }
        if (nextStart != 0) {
            newText.append(text.substring(nextStart));
        }
        return !newText.isEmpty() ? newText.toString() : text;
    }

    public static String processModuleIDsInText(String text) {
        StringBuilder newText = new StringBuilder();
        Matcher matcher = FULLY_QUALIFIED_MODULE_ID_PATTERN.matcher(text);
        int nextStart = 0;
        while (matcher.find()) {
            newText.append(text, nextStart, matcher.start(1));
            String modPart = matcher.group(2);
            int last = modPart.lastIndexOf(".");
            if (last != -1) {
                modPart = modPart.substring(last + 1);
            }
            String typeName = matcher.group(4);
            newText.append(modPart);
            newText.append(":");
            newText.append(typeName);
            nextStart = matcher.end(4);
        }
        if (nextStart != 0 && nextStart < text.length()) {
            newText.append(text.substring(nextStart));
        }
        return !newText.isEmpty() ? newText.toString() : text;
    }

    public static String generateFunction(DocumentServiceContext context, boolean newLineAtStart, String functionName, List<String> args, TypeSymbol returnTypeSymbol) {
        return FunctionGenerator.generateFunction(context, newLineAtStart, functionName, args, returnTypeSymbol, false);
    }

    public static String generateFunction(DocumentServiceContext context, boolean newLineAtEnd, String functionName, List<String> args, TypeSymbol returnTypeSymbol, boolean isolated) {
        String returnType = null;
        if (returnTypeSymbol.typeKind() != TypeDescKind.COMPILATION_ERROR && returnTypeSymbol.typeKind() != TypeDescKind.NIL) {
            returnType = FunctionGenerator.getReturnTypeAsString(context, returnTypeSymbol.signature());
        }
        Object returnsClause = "";
        Object returnStmt = "";
        if (returnType != null) {
            returnsClause = "returns " + returnType;
            Optional<String> defaultReturnValue = DefaultValueGenerationUtil.getDefaultValueForType(returnTypeSymbol);
            if (defaultReturnValue.isPresent()) {
                returnStmt = "return " + defaultReturnValue.get() + ";";
            }
        }
        return FunctionGenerator.generateFunction(functionName, args, (String)returnsClause, (String)returnStmt, newLineAtEnd, isolated, "");
    }

    public static String generateFunction(String functionName, List<String> args, String returnsClause, String returnStmt, boolean newLineAtEnd, boolean isolated, String funcBodyExcludingRetStmt) {
        int padding = 4;
        String paddingStr = StringUtils.repeat((String)" ", (int)padding);
        Object body = "";
        if (!funcBodyExcludingRetStmt.isEmpty()) {
            body = (String)body + funcBodyExcludingRetStmt;
        }
        if (!returnStmt.isEmpty()) {
            body = (String)body + paddingStr + returnStmt + CommonUtil.LINE_SEPARATOR;
        } else if (funcBodyExcludingRetStmt.isEmpty()) {
            body = (String)body + paddingStr + CommonUtil.LINE_SEPARATOR;
        }
        StringBuilder fnBuilder = new StringBuilder();
        if (!functionName.isEmpty()) {
            fnBuilder.append(CommonUtil.LINE_SEPARATOR).append(CommonUtil.LINE_SEPARATOR);
        }
        if (isolated) {
            fnBuilder.append("isolated ");
        }
        fnBuilder.append("function").append(" ").append(functionName).append("(").append(String.join((CharSequence)", ", args)).append(")");
        if (!returnsClause.isEmpty()) {
            fnBuilder.append(" ").append(returnsClause);
        }
        fnBuilder.append(" ").append("{").append(CommonUtil.LINE_SEPARATOR).append((String)body).append("}");
        if (!functionName.isEmpty() && newLineAtEnd) {
            fnBuilder.append(CommonUtil.LINE_SEPARATOR);
        }
        return fnBuilder.toString();
    }

    public static String generateFunctionName(String functionPrefix, List<Symbol> visibleSymbols) {
        Set<String> visibleSymbolNames = visibleSymbols.stream().map(Symbol::getName).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        return NameUtil.generateTypeName(functionPrefix, visibleSymbolNames);
    }

    public static String getReturnTypeAsString(DocumentServiceContext context, String signature) {
        ImportsAcceptor importsAcceptor = new ImportsAcceptor(context);
        return FunctionGenerator.processModuleIDsInText(importsAcceptor, signature, context);
    }

    public static String getParameterTypeAsString(DocumentServiceContext context, TypeSymbol typeSymbol) {
        if (typeSymbol == null || typeSymbol.typeKind() == TypeDescKind.COMPILATION_ERROR) {
            return TypeDescKind.ANY.getName();
        }
        ImportsAcceptor importsAcceptor = new ImportsAcceptor(context);
        return FunctionGenerator.processModuleIDsInText(importsAcceptor, typeSymbol.signature(), context);
    }
}

