/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.common.utils;

import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ballerinalang.langserver.common.RecordField;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.DefaultValueGenerationUtil;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.ballerinalang.langserver.common.utils.RawTypeSymbolWrapper;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.SnippetContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.RecordFieldCompletionItem;
import org.ballerinalang.langserver.completions.StaticCompletionItem;
import org.ballerinalang.langserver.completions.util.Priority;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;

public final class RecordUtil {
    private RecordUtil() {
    }

    public static List<LSCompletionItem> getRecordFieldCompletionItems(BallerinaCompletionContext context, Map<RecordField.RecordFieldIdentifier, List<RecordField>> fieldsMap) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        fieldsMap.forEach((recordFieldIdentifier, fields) -> completionItems.add(RecordUtil.getRecordFieldCompletionItem(context, recordFieldIdentifier, fields)));
        return completionItems;
    }

    private static LSCompletionItem getRecordFieldCompletionItem(BallerinaCompletionContext context, RecordField.RecordFieldIdentifier recordFieldIdentifier, List<RecordField> fields) {
        RecordField recordField = fields.get(0);
        String name = recordFieldIdentifier.getName();
        SnippetContext snippetContext = new SnippetContext();
        String insertText = RecordUtil.getRecordFieldCompletionInsertText(recordField.getFieldSymbol(), snippetContext);
        String detail = fields.stream().map(field -> {
            RawTypeSymbolWrapper<RecordTypeSymbol> wrapper = field.getTypeSymbolWrapper();
            if (wrapper.getBroaderType().getName().isPresent()) {
                return NameUtil.getModifiedTypeName((DocumentServiceContext)context, wrapper.getBroaderType()) + "." + name;
            }
            return "(" + wrapper.getRawType().signature() + ")." + name;
        }).collect(Collectors.joining("|"));
        CompletionItem fieldItem = new CompletionItem();
        fieldItem.setInsertText(insertText);
        fieldItem.setInsertTextFormat(InsertTextFormat.Snippet);
        fieldItem.setLabel(CommonUtil.escapeReservedKeyword(name));
        fieldItem.setKind(CompletionItemKind.Field);
        fieldItem.setSortText(Priority.PRIORITY120.toString());
        return new RecordFieldCompletionItem(context, recordField.getFieldSymbol(), fieldItem, detail);
    }

    public static Optional<LSCompletionItem> getFillAllRecordFieldCompletionItems(BallerinaCompletionContext context, Map<String, RecordFieldSymbol> fields, RawTypeSymbolWrapper<RecordTypeSymbol> wrapper) {
        ArrayList<CallSite> fieldEntries = new ArrayList<CallSite>();
        HashMap<String, RecordFieldSymbol> requiredFields = new HashMap<String, RecordFieldSymbol>();
        for (Map.Entry<String, RecordFieldSymbol> entry : fields.entrySet()) {
            if (entry.getValue().isOptional() || entry.getValue().hasDefaultValue()) continue;
            requiredFields.put(CommonUtil.escapeReservedKeyword(entry.getKey()), entry.getValue());
        }
        String detail = NameUtil.getRecordTypeName((DocumentServiceContext)context, wrapper);
        if (!requiredFields.isEmpty()) {
            String label = "Fill " + detail + " Required Fields";
            SnippetContext snippetContext = new SnippetContext();
            for (Map.Entry entry : requiredFields.entrySet()) {
                String fieldEntry = (String)entry.getKey() + ": " + DefaultValueGenerationUtil.getDefaultValueForType(((RecordFieldSymbol)entry.getValue()).typeDescriptor(), snippetContext).orElse(" ");
                fieldEntries.add((CallSite)((Object)fieldEntry));
            }
            String insertText = String.join((CharSequence)("," + CommonUtil.LINE_SEPARATOR), fieldEntries);
            CompletionItem completionItem = new CompletionItem();
            completionItem.setFilterText("fill");
            completionItem.setLabel(label);
            completionItem.setInsertText(insertText);
            completionItem.setDetail(detail);
            completionItem.setKind(CompletionItemKind.Property);
            completionItem.setSortText(Priority.PRIORITY110.toString());
            return Optional.of(new StaticCompletionItem(context, completionItem, StaticCompletionItem.Kind.OTHER));
        }
        return Optional.empty();
    }

    public static String getFillAllRecordFieldInsertText(Map<String, RecordFieldSymbol> fields) {
        ArrayList<CallSite> fieldEntries = new ArrayList<CallSite>();
        HashMap<String, RecordFieldSymbol> requiredFields = new HashMap<String, RecordFieldSymbol>();
        for (Map.Entry<String, RecordFieldSymbol> entry : fields.entrySet()) {
            if (entry.getValue().isOptional() || entry.getValue().hasDefaultValue()) continue;
            requiredFields.put(CommonUtil.escapeReservedKeyword(entry.getKey()), entry.getValue());
        }
        String insertText = "";
        if (!requiredFields.isEmpty()) {
            for (Map.Entry entry : requiredFields.entrySet()) {
                String fieldEntry = (String)entry.getKey() + ": " + DefaultValueGenerationUtil.getDefaultValueForType(((RecordFieldSymbol)entry.getValue()).typeDescriptor()).orElse(" ");
                fieldEntries.add((CallSite)((Object)fieldEntry));
            }
            insertText = String.join((CharSequence)", ", fieldEntries);
        }
        return insertText;
    }

    public static Map<String, RecordFieldSymbol> getRecordFields(RawTypeSymbolWrapper<RecordTypeSymbol> wrapper, List<String> existingFields) {
        return wrapper.getRawType().fieldDescriptors().entrySet().stream().filter(e -> !existingFields.contains(((RecordFieldSymbol)e.getValue()).getName().get())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static List<RecordFieldSymbol> getMandatoryRecordFields(RecordTypeSymbol recordType) {
        return recordType.fieldDescriptors().values().stream().filter(field -> !field.hasDefaultValue() && !field.isOptional()).toList();
    }

    public static String getRecordFieldCompletionInsertText(RecordFieldSymbol bField, SnippetContext snippetContext) {
        StringBuilder insertText = new StringBuilder(CommonUtil.escapeReservedKeyword((String)bField.getName().get()) + ": ");
        insertText.append(DefaultValueGenerationUtil.getDefaultValueForType(bField.typeDescriptor(), snippetContext).orElse(" "));
        return insertText.toString();
    }

    public static List<RawTypeSymbolWrapper<RecordTypeSymbol>> getRecordTypeSymbols(TypeSymbol typeSymbol) {
        TypeSymbol rawType = CommonUtil.getRawType(typeSymbol);
        if (rawType.typeKind() == TypeDescKind.RECORD) {
            return Collections.singletonList(RawTypeSymbolWrapper.from(typeSymbol, (RecordTypeSymbol)rawType));
        }
        if (rawType.typeKind() == TypeDescKind.UNION) {
            return ((UnionTypeSymbol)rawType).memberTypeDescriptors().stream().filter(tSymbol -> CommonUtil.getRawType(tSymbol).typeKind() == TypeDescKind.RECORD).map(tSymbol -> {
                RecordTypeSymbol recordTypeSymbol = (RecordTypeSymbol)CommonUtil.getRawType(tSymbol);
                return RawTypeSymbolWrapper.from(tSymbol, recordTypeSymbol);
            }).toList();
        }
        return Collections.emptyList();
    }
}

