/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.builder;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ParameterKind;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.PathParameterSymbol;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.resourcepath.PathRestParam;
import io.ballerina.compiler.api.symbols.resourcepath.PathSegmentList;
import io.ballerina.compiler.api.symbols.resourcepath.ResourcePath;
import io.ballerina.compiler.api.symbols.resourcepath.util.PathSegment;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.ModuleUtil;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.StaticCompletionItem;
import org.ballerinalang.langserver.completions.providers.context.util.ModulePartNodeContextUtil;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.SnippetGenerator;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public final class FunctionCompletionItemBuilder {
    private FunctionCompletionItemBuilder() {
    }

    public static CompletionItem build(FunctionSymbol functionSymbol, BallerinaCompletionContext context) {
        CompletionItem item = new CompletionItem();
        FunctionCompletionItemBuilder.setMeta(item, functionSymbol, context);
        if (functionSymbol != null && functionSymbol.getName().isPresent()) {
            String funcName = (String)functionSymbol.getName().get();
            Pair<String, String> functionSignature = FunctionCompletionItemBuilder.getFunctionInvocationSignature(functionSymbol, funcName, context);
            item.setLabel((String)functionSignature.getRight());
            item.setInsertText((String)functionSignature.getLeft());
            item.setFilterText(funcName);
        }
        return item;
    }

    public static CompletionItem buildFunctionPointer(FunctionSymbol functionSymbol, BallerinaCompletionContext context) {
        CompletionItem item = new CompletionItem();
        FunctionCompletionItemBuilder.setMeta(item, functionSymbol, context);
        if (functionSymbol != null) {
            String funcName = functionSymbol.getName().orElse("");
            item.setInsertText(CommonUtil.escapeSpecialCharsInInsertText(funcName));
            item.setLabel(funcName);
            item.setFilterText(funcName);
            item.setKind(CompletionItemKind.Variable);
        }
        return item;
    }

    public static CompletionItem build(ClassSymbol typeDesc, InitializerBuildMode mode, BallerinaCompletionContext ctx) {
        MethodSymbol initMethod = null;
        if (typeDesc.initMethod().isPresent()) {
            initMethod = (MethodSymbol)typeDesc.initMethod().get();
        }
        CompletionItem item = new CompletionItem();
        FunctionCompletionItemBuilder.setMeta(item, (FunctionSymbol)initMethod, ctx);
        String functionName = mode == InitializerBuildMode.EXPLICIT ? FunctionCompletionItemBuilder.getQualifiedFunctionName((String)typeDesc.getName().get(), ctx, (FunctionSymbol)initMethod) : "new";
        Pair<String, String> functionSignature = FunctionCompletionItemBuilder.getFunctionInvocationSignature((FunctionSymbol)initMethod, functionName, ctx);
        item.setInsertText((String)functionSignature.getLeft());
        item.setLabel((String)functionSignature.getRight());
        return item;
    }

    public static CompletionItem buildMethod(@Nonnull FunctionSymbol functionSymbol, BallerinaCompletionContext context) {
        CompletionItem item = new CompletionItem();
        FunctionCompletionItemBuilder.setMeta(item, functionSymbol, context);
        String funcName = (String)functionSymbol.getName().get();
        Pair<String, String> functionSignature = FunctionCompletionItemBuilder.getFunctionInvocationSignature(functionSymbol, funcName, context);
        item.setInsertText("self." + (String)functionSignature.getLeft());
        item.setLabel("self." + (String)functionSignature.getRight());
        item.setFilterText("self." + funcName);
        return item;
    }

    static void setMeta(CompletionItem item, FunctionSymbol functionSymbol, BallerinaCompletionContext ctx) {
        item.setInsertTextFormat(InsertTextFormat.Snippet);
        item.setKind(CompletionItemKind.Function);
        if (functionSymbol != null) {
            FunctionTypeSymbol functionTypeDesc = functionSymbol.typeDescriptor();
            Optional typeSymbol = functionTypeDesc.returnTypeDescriptor();
            typeSymbol.ifPresent(symbol -> item.setDetail(NameUtil.getModifiedTypeName((DocumentServiceContext)ctx, symbol)));
            List<String> funcArguments = CommonUtil.getFuncArguments(functionSymbol, ctx);
            if (!funcArguments.isEmpty()) {
                Command cmd = new Command("editor.action.triggerParameterHints", "editor.action.triggerParameterHints");
                item.setCommand(cmd);
            }
            boolean skipFirstParam = CommonUtil.skipFirstParam(ctx, functionSymbol);
            if (functionSymbol.documentation().isPresent()) {
                item.setDocumentation(FunctionCompletionItemBuilder.getDocumentation(functionSymbol, skipFirstParam, ctx));
            }
        }
    }

    private static Either<String, MarkupContent> getDocumentation(FunctionSymbol functionSymbol, boolean skipFirstParam, BallerinaCompletionContext ctx) {
        FunctionTypeSymbol functionTypeDesc = functionSymbol.typeDescriptor();
        Optional docAttachment = functionSymbol.documentation();
        String description = docAttachment.isEmpty() || ((Documentation)docAttachment.get()).description().isEmpty() ? "" : (String)((Documentation)docAttachment.get()).description().get();
        HashMap docParamsMap = new HashMap();
        docAttachment.ifPresent(documentation -> documentation.parameterMap().forEach(docParamsMap::put));
        ArrayList<ParameterSymbol> functionParameters = new ArrayList<ParameterSymbol>();
        ArrayList<ParameterSymbol> defaultParams = new ArrayList<ParameterSymbol>();
        if (functionTypeDesc.params().isPresent()) {
            functionParameters.addAll((Collection)functionTypeDesc.params().get());
            defaultParams.addAll(functionParameters.stream().filter(parameter -> parameter.paramKind() == ParameterKind.DEFAULTABLE).toList());
        }
        MarkupContent docMarkupContent = new MarkupContent();
        docMarkupContent.setKind("markdown");
        StringBuilder documentation2 = new StringBuilder();
        if (functionSymbol.getModule().isPresent()) {
            String moduleId = ((ModuleSymbol)functionSymbol.getModule().get()).id().toString();
            documentation2.append("**Package:** _").append(moduleId).append("_").append(CommonUtil.MD_LINE_SEPARATOR).append(CommonUtil.MD_LINE_SEPARATOR);
        }
        documentation2.append(description).append(CommonUtil.MD_LINE_SEPARATOR);
        StringJoiner joiner = new StringJoiner(CommonUtil.MD_LINE_SEPARATOR);
        if (functionSymbol.kind() == SymbolKind.RESOURCE_METHOD) {
            ResourcePath resourcePath = ((ResourceMethodSymbol)functionSymbol).resourcePath();
            ArrayList<PathParameterSymbol> pathParameterSymbols = new ArrayList<PathParameterSymbol>();
            switch (resourcePath.kind()) {
                case PATH_SEGMENT_LIST: {
                    PathSegmentList pathSegmentList = (PathSegmentList)resourcePath;
                    pathParameterSymbols.addAll(pathSegmentList.pathParameters());
                    if (!pathSegmentList.pathRestParameter().isPresent()) break;
                    pathParameterSymbols.add((PathParameterSymbol)pathSegmentList.pathRestParameter().get());
                    break;
                }
                case PATH_REST_PARAM: {
                    pathParameterSymbols.add(((PathRestParam)resourcePath).parameter());
                    break;
                }
            }
            for (PathParameterSymbol pathParameterSymbol : pathParameterSymbols) {
                String paramType = NameUtil.getModifiedTypeName((DocumentServiceContext)ctx, pathParameterSymbol.typeDescriptor());
                StringBuilder paramDescription = new StringBuilder("- `" + paramType + "`");
                pathParameterSymbol.getName().ifPresent(name -> {
                    paramDescription.append(" ").append((String)name);
                    if (docParamsMap.containsKey(name)) {
                        paramDescription.append(": ").append((String)docParamsMap.get(name));
                    }
                });
                joiner.add(paramDescription);
            }
        }
        if (functionTypeDesc.restParam().isPresent()) {
            functionParameters.add((ParameterSymbol)functionTypeDesc.restParam().get());
        }
        for (int i = 0; i < functionParameters.size(); ++i) {
            ParameterSymbol param = (ParameterSymbol)functionParameters.get(i);
            String paramType = NameUtil.getModifiedTypeName((DocumentServiceContext)ctx, param.typeDescriptor());
            if (i == 0 && skipFirstParam) continue;
            Optional<ParameterSymbol> defaultVal = defaultParams.stream().filter(parameter -> parameter.getName().isPresent() && param.getName().isPresent() && ((String)parameter.getName().get()).equals(param.getName().get())).findFirst();
            StringBuilder paramDescription = new StringBuilder("- `" + paramType + "`");
            param.getName().ifPresent(name -> {
                paramDescription.append(" ").append((String)name);
                if (docParamsMap.containsKey(name)) {
                    paramDescription.append(": ").append((String)docParamsMap.get(name));
                }
            });
            if (defaultVal.isPresent()) {
                joiner.add(String.valueOf(paramDescription) + "(Defaultable)");
                continue;
            }
            joiner.add(paramDescription);
        }
        String paramsStr = joiner.toString();
        if (!paramsStr.isEmpty()) {
            documentation2.append("**Params**").append(CommonUtil.MD_LINE_SEPARATOR).append(paramsStr);
        }
        if (functionTypeDesc.returnTypeDescriptor().isPresent() && ((TypeSymbol)functionTypeDesc.returnTypeDescriptor().get()).typeKind() != TypeDescKind.NIL) {
            Object desc = "";
            if (docAttachment.isPresent() && ((Documentation)docAttachment.get()).returnDescription().isPresent() && !((String)((Documentation)docAttachment.get()).returnDescription().get()).isEmpty()) {
                desc = "- " + CommonUtil.MD_NEW_LINE_PATTERN.matcher((CharSequence)((Documentation)docAttachment.get()).returnDescription().get()).replaceAll(CommonUtil.MD_LINE_SEPARATOR) + CommonUtil.MD_LINE_SEPARATOR;
            }
            documentation2.append(CommonUtil.MD_LINE_SEPARATOR).append(CommonUtil.MD_LINE_SEPARATOR).append("**Return**").append(" `").append(NameUtil.getModifiedTypeName((DocumentServiceContext)ctx, (TypeSymbol)functionTypeDesc.returnTypeDescriptor().get())).append("` ").append(CommonUtil.MD_LINE_SEPARATOR).append((String)desc).append(CommonUtil.MD_LINE_SEPARATOR);
        }
        docMarkupContent.setValue(documentation2.toString());
        return Either.forRight((Object)docMarkupContent);
    }

    private static Pair<String, String> getFunctionInvocationSignature(FunctionSymbol functionSymbol, String functionName, BallerinaCompletionContext ctx) {
        String escapedFunctionName = CommonUtil.escapeEscapeCharsInIdentifier(functionName);
        if (functionSymbol == null) {
            return ImmutablePair.of((Object)(escapedFunctionName + "()"), (Object)(functionName + "()"));
        }
        StringBuilder signature = new StringBuilder(functionName + "(");
        StringBuilder insertText = new StringBuilder(escapedFunctionName + "(");
        List<String> funcArguments = CommonUtil.getFuncArguments(functionSymbol, ctx);
        if (!funcArguments.isEmpty()) {
            signature.append(String.join((CharSequence)", ", funcArguments));
            insertText.append("${1}");
        }
        signature.append(")");
        insertText.append(")");
        return new ImmutablePair((Object)insertText.toString(), (Object)signature.toString());
    }

    public static Optional<String> getFunctionParameterSyntax(PathParameterSymbol param, BallerinaCompletionContext ctx) {
        if (param.pathSegmentKind() == PathSegment.Kind.PATH_REST_PARAMETER) {
            return Optional.of(NameUtil.getModifiedTypeName((DocumentServiceContext)ctx, param.typeDescriptor()) + (String)(param.getName().isEmpty() ? "" : "... " + (String)param.getName().get()));
        }
        if (param.typeDescriptor().typeKind() == TypeDescKind.COMPILATION_ERROR) {
            return Optional.empty();
        }
        return Optional.of(NameUtil.getModifiedTypeName((DocumentServiceContext)ctx, param.typeDescriptor()) + (String)(param.getName().isEmpty() || param.isTypeOnlyParam() ? "" : " " + (String)param.getName().get()));
    }

    private static String getQualifiedFunctionName(String functionName, BallerinaCompletionContext ctx, @Nullable FunctionSymbol functionSymbol) {
        if (functionSymbol == null) {
            return functionName;
        }
        boolean onQNameRef = QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)ctx, (Node)ctx.getNodeAtCursor());
        Optional module = functionSymbol.getModule();
        if (module.isEmpty() || onQNameRef || functionName.equals(SyntaxKind.NEW_KEYWORD.stringValue())) {
            return functionName;
        }
        ModuleID moduleID = ((ModuleSymbol)module.get()).id();
        String modulePrefix = ModuleUtil.getModulePrefix((DocumentServiceContext)ctx, moduleID.orgName(), moduleID.moduleName());
        if (modulePrefix.isEmpty()) {
            return functionName;
        }
        return modulePrefix + SyntaxKind.COLON_TOKEN.stringValue() + functionName;
    }

    public static LSCompletionItem buildMainFunction(BallerinaCompletionContext context) {
        Optional<Object> lastQualifier = Optional.empty();
        for (NonTerminalNode node = context.getNodeAtCursor(); node != null && !(lastQualifier = ModulePartNodeContextUtil.getLastQualifier(context, (Node)node)).isPresent() && node.kind() != SyntaxKind.MODULE_PART; node = node.parent()) {
        }
        CompletionItem completionItem = new CompletionItem();
        String insertText = lastQualifier.isPresent() && ((Token)lastQualifier.get()).kind() == SyntaxKind.PUBLIC_KEYWORD ? "function main() " : "public function main() ";
        completionItem.setInsertText(insertText + "{" + CommonUtil.LINE_SEPARATOR + "\t${1}" + CommonUtil.LINE_SEPARATOR + "}");
        completionItem.setLabel("public main function");
        completionItem.setFilterText(SnippetGenerator.generateFilterText(Arrays.asList("public", "function", "main")));
        completionItem.setKind(CompletionItemKind.Snippet);
        completionItem.setDetail("Snippet");
        return new StaticCompletionItem(context, completionItem, StaticCompletionItem.Kind.MAIN_FUNCTION);
    }

    public static enum InitializerBuildMode {
        EXPLICIT,
        IMPLICIT;

    }
}

