/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.builder;

import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.CompoundAssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.ExpressionStatementNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.Token;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;

class OptionalFieldAccessWriteAmbiguityResolver
extends NodeTransformer<Boolean> {
    private final BallerinaCompletionContext context;

    public OptionalFieldAccessWriteAmbiguityResolver(BallerinaCompletionContext context) {
        this.context = context;
    }

    public Boolean transform(ExpressionStatementNode node) {
        return Boolean.FALSE;
    }

    public Boolean transform(AssignmentStatementNode node) {
        int cursor = this.context.getCursorPositionInTree();
        Token equalsToken = node.equalsToken();
        return !equalsToken.isMissing() && cursor > equalsToken.textRange().startOffset();
    }

    public Boolean transform(CompoundAssignmentStatementNode node) {
        int cursor = this.context.getCursorPositionInTree();
        Token binaryOperator = node.binaryOperator();
        return !binaryOperator.isMissing() && cursor > binaryOperator.textRange().startOffset();
    }

    public Boolean transform(FieldAccessExpressionNode node) {
        return this.visit((Node)node.parent());
    }

    public Boolean transform(MethodCallExpressionNode node) {
        return this.visit((Node)node.parent());
    }

    public Boolean transform(SimpleNameReferenceNode node) {
        return this.visit((Node)node.parent());
    }

    protected Boolean transformSyntaxNode(Node node) {
        return Boolean.TRUE;
    }

    private Boolean visit(Node node) {
        if (node == null) {
            return Boolean.TRUE;
        }
        return (Boolean)node.apply((NodeTransformer)this);
    }
}

