/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.builder;

import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.resourcepath.PathRestParam;
import io.ballerina.compiler.api.symbols.resourcepath.PathSegmentList;
import io.ballerina.compiler.api.symbols.resourcepath.ResourcePath;
import io.ballerina.compiler.api.symbols.resourcepath.util.PathSegment;
import io.ballerina.compiler.syntax.tree.ClientResourceAccessActionNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.tuple.Pair;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.completions.builder.FunctionCompletionItemBuilder;
import org.ballerinalang.langserver.completions.builder.ResourcePathCompletionUtil;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.TextEdit;

public final class ResourcePathCompletionItemBuilder {
    private ResourcePathCompletionItemBuilder() {
    }

    public static List<CompletionItem> build(ResourceMethodSymbol functionSymbol, BallerinaCompletionContext context) {
        ResourcePath resourcePath = functionSymbol.resourcePath();
        if (resourcePath.kind() == ResourcePath.Kind.PATH_SEGMENT_LIST) {
            return ResourcePathCompletionItemBuilder.build(functionSymbol, ((PathSegmentList)resourcePath).list(), context);
        }
        if (resourcePath.kind() == ResourcePath.Kind.PATH_REST_PARAM) {
            return ResourcePathCompletionItemBuilder.build(functionSymbol, List.of(((PathRestParam)resourcePath).parameter()), context);
        }
        return ResourcePathCompletionItemBuilder.build(functionSymbol, Collections.emptyList(), context);
    }

    public static List<CompletionItem> build(ResourceMethodSymbol resourceMethodSymbol, List<PathSegment> segments, BallerinaCompletionContext context) {
        List<Pair<String, String>> resourceAccessInfo = ResourcePathCompletionUtil.getResourceAccessInfo(resourceMethodSymbol, context, segments);
        return resourceAccessInfo.stream().map(info -> {
            CompletionItem item = ResourcePathCompletionItemBuilder.buildCompletionItem(resourceMethodSymbol, (Pair<String, String>)info, context);
            item.setFilterText(ResourcePathCompletionUtil.getFilterTextForClientResourceAccessAction(resourceMethodSymbol, segments));
            return item;
        }).toList();
    }

    private static CompletionItem buildCompletionItem(ResourceMethodSymbol resourceMethodSymbol, Pair<String, String> functionSignature, BallerinaCompletionContext context) {
        CompletionItem item = new CompletionItem();
        FunctionCompletionItemBuilder.setMeta(item, (FunctionSymbol)resourceMethodSymbol, context);
        item.setLabel((String)functionSignature.getRight());
        item.setInsertText((String)functionSignature.getLeft());
        ResourcePathCompletionItemBuilder.checkAndSetAdditionalTextEdits(item, context);
        return item;
    }

    public static CompletionItem buildMethodCallExpression(ResourceMethodSymbol resourceMethodSymbol, BallerinaCompletionContext context) {
        CompletionItem item = new CompletionItem();
        FunctionCompletionItemBuilder.setMeta(item, (FunctionSymbol)resourceMethodSymbol, context);
        String functionName = resourceMethodSymbol.getName().orElse("");
        String escapedFunctionName = CommonUtil.escapeEscapeCharsInIdentifier(functionName);
        StringBuilder signature = new StringBuilder();
        StringBuilder insertText = new StringBuilder();
        ResourcePathCompletionUtil.addResourceMethodCallSignature(resourceMethodSymbol, context, escapedFunctionName, signature, insertText, 1);
        item.setLabel(signature.toString());
        item.setInsertText(insertText.toString());
        item.setFilterText(resourceMethodSymbol.getName().orElse(""));
        ResourcePathCompletionItemBuilder.checkAndSetAdditionalTextEdits(item, context);
        return item;
    }

    private static void checkAndSetAdditionalTextEdits(CompletionItem item, BallerinaCompletionContext context) {
        Token finalToken;
        Token token = null;
        Optional<ClientResourceAccessActionNode> node = ResourcePathCompletionUtil.findClientResourceAccessActionNode(context);
        if (node.isPresent()) {
            if (ResourcePathCompletionUtil.isInMethodCallContext(node.get(), context)) {
                if (node.get().resourceAccessPath().isEmpty() && !node.get().slashToken().isMissing()) {
                    item.setAdditionalTextEdits(List.of(new TextEdit(PositionUtil.toRange(node.get().slashToken().lineRange()), ""), new TextEdit(PositionUtil.toRange(((Token)node.get().dotToken().get()).lineRange()), "")));
                    return;
                }
                token = (Token)node.get().dotToken().get();
            } else {
                SeparatedNodeList nodes = node.get().resourceAccessPath();
                if (nodes.separatorSize() > 0 && nodes.getSeparator(nodes.separatorSize() - 1).textRange().endOffset() <= context.getCursorPositionInTree()) {
                    token = nodes.getSeparator(nodes.separatorSize() - 1);
                } else if (nodes.separatorSize() == 0 && !node.get().slashToken().isMissing()) {
                    token = node.get().slashToken();
                }
            }
        }
        if ((finalToken = token) != null && node.get().resourceAccessPath().stream().noneMatch(child -> child.kind() == SyntaxKind.COMPUTED_RESOURCE_ACCESS_SEGMENT && finalToken.textRange().startOffset() <= child.textRange().startOffset())) {
            TextEdit edit = new TextEdit();
            edit.setNewText("");
            edit.setRange(PositionUtil.toRange(token.lineRange()));
            item.setAdditionalTextEdits(List.of(edit));
        }
    }
}

