/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.builder;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.ModuleUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.MarkupContent;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public final class StreamTypeInitCompletionItemBuilder {
    private StreamTypeInitCompletionItemBuilder() {
    }

    public static CompletionItem build() {
        CompletionItem item = new CompletionItem();
        String label = "new()";
        item.setInsertText(label);
        item.setLabel(label);
        item.setInsertTextFormat(InsertTextFormat.Snippet);
        item.setKind(CompletionItemKind.Function);
        return item;
    }

    public static CompletionItem build(TypeDefinitionSymbol symbol, BallerinaCompletionContext context) {
        CompletionItem item = new CompletionItem();
        String label = StreamTypeInitCompletionItemBuilder.getQualifiedFunctionName(context, symbol) + "()";
        item.setInsertText(label);
        item.setLabel(label);
        item.setInsertTextFormat(InsertTextFormat.Snippet);
        item.setKind(CompletionItemKind.Function);
        if (symbol.documentation().isPresent()) {
            item.setDocumentation(StreamTypeInitCompletionItemBuilder.getDocumentation(symbol));
        }
        return item;
    }

    private static String getQualifiedFunctionName(BallerinaCompletionContext ctx, TypeDefinitionSymbol typeDefinitionSymbol) {
        boolean onQNameRef = QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)ctx, (Node)ctx.getNodeAtCursor());
        Optional module = typeDefinitionSymbol.getModule();
        if (module.isEmpty() || onQNameRef) {
            return (String)typeDefinitionSymbol.getName().get();
        }
        ModuleID moduleID = ((ModuleSymbol)module.get()).id();
        String modulePrefix = ModuleUtil.getModulePrefix((DocumentServiceContext)ctx, moduleID.orgName(), moduleID.moduleName());
        if (modulePrefix.isEmpty() || modulePrefix.equals("annotations")) {
            return (String)typeDefinitionSymbol.getName().get();
        }
        return modulePrefix + SyntaxKind.COLON_TOKEN.stringValue() + (String)typeDefinitionSymbol.getName().get();
    }

    private static Either<String, MarkupContent> getDocumentation(TypeDefinitionSymbol typeDefinitionSymbol) {
        Optional docAttachment = typeDefinitionSymbol.documentation();
        String description = docAttachment.isEmpty() || ((Documentation)docAttachment.get()).description().isEmpty() ? "" : (String)((Documentation)docAttachment.get()).description().get();
        MarkupContent docMarkupContent = new MarkupContent();
        docMarkupContent.setKind("markdown");
        StringBuilder documentation = new StringBuilder();
        if (typeDefinitionSymbol.getModule().isPresent()) {
            String moduleId = ((ModuleSymbol)typeDefinitionSymbol.getModule().get()).id().toString();
            documentation.append("**Package:** _").append(moduleId).append("_").append(CommonUtil.MD_LINE_SEPARATOR).append(CommonUtil.MD_LINE_SEPARATOR);
        }
        documentation.append(description).append(CommonUtil.MD_LINE_SEPARATOR);
        docMarkupContent.setValue(documentation.toString());
        return Either.forRight((Object)docMarkupContent);
    }
}

