/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationAttachPointNode;
import io.ballerina.compiler.syntax.tree.AnnotationDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;

public class AnnotationDeclarationNodeContext
extends AbstractCompletionProvider<AnnotationDeclarationNode> {
    public AnnotationDeclarationNodeContext() {
        super(AnnotationDeclarationNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, AnnotationDeclarationNode node) {
        ArrayList<LSCompletionItem> completionItemList = new ArrayList<LSCompletionItem>();
        if (this.onTypeDescriptorContext(context, node)) {
            Predicate<Symbol> predicate = symbol -> symbol.kind() == SymbolKind.TYPE_DEFINITION && this.isValidTypeDescForAnnotations((TypeDefinitionSymbol)symbol);
            if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)context.getNodeAtCursor())) {
                QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)context.getNodeAtCursor();
                List<Symbol> filteredSymbols = QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)context, qNameRef, predicate);
                completionItemList.addAll(this.getCompletionItemList(filteredSymbols, context));
            } else {
                List<Symbol> filteredSymbols = context.visibleSymbols(context.getCursorPosition()).stream().filter(predicate).toList();
                completionItemList.addAll(this.getCompletionItemList(filteredSymbols, context));
                completionItemList.addAll(this.getModuleCompletionItems(context));
                completionItemList.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_RECORD_TYPE_DESC.get()));
                completionItemList.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_CLOSED_RECORD_TYPE_DESC.get()));
            }
        } else if (this.onSuggestOnKeyword(context, node)) {
            completionItemList.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_ON.get()));
        } else if (this.onSuggestAttachmentPoints(context, node)) {
            completionItemList.addAll(this.getAnnotationAttachmentPoints(context, node));
        }
        this.sort(context, node, completionItemList);
        return completionItemList;
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, AnnotationDeclarationNode node) {
        Token annotationKeyword = node.annotationKeyword();
        Token semicolonToken = node.semicolonToken();
        int cursor = context.getCursorPositionInTree();
        return !annotationKeyword.isMissing() && cursor >= annotationKeyword.textRange().endOffset() && (semicolonToken.isMissing() || cursor < semicolonToken.textRange().endOffset());
    }

    private boolean onTypeDescriptorContext(BallerinaCompletionContext context, AnnotationDeclarationNode node) {
        Optional typeDesc = node.typeDescriptor();
        Token annotationTag = node.annotationTag();
        int cursor = context.getCursorPositionInTree();
        return typeDesc.isEmpty() && annotationTag.isMissing() || typeDesc.isEmpty() && !annotationTag.isMissing() && cursor <= annotationTag.textRange().endOffset() || typeDesc.isPresent() && cursor >= ((Node)typeDesc.get()).textRange().startOffset() && cursor <= ((Node)typeDesc.get()).textRange().endOffset();
    }

    private boolean onSuggestOnKeyword(BallerinaCompletionContext context, AnnotationDeclarationNode node) {
        Token annotationTag = node.annotationTag();
        SeparatedNodeList attachPoints = node.attachPoints();
        int cursor = context.getCursorPositionInTree();
        return !annotationTag.isMissing() && attachPoints.isEmpty() && node.onKeyword().isEmpty() && annotationTag.textRange().endOffset() + 1 <= cursor;
    }

    private boolean onSuggestAttachmentPoints(BallerinaCompletionContext context, AnnotationDeclarationNode node) {
        Optional onKeyword = node.onKeyword();
        int cursor = context.getCursorPositionInTree();
        return onKeyword.isPresent() && cursor >= ((Token)onKeyword.get()).textRange().endOffset() + 1;
    }

    private boolean isValidTypeDescForAnnotations(TypeDefinitionSymbol typeDefinitionSymbol) {
        TypeSymbol typeSymbol = typeDefinitionSymbol.typeDescriptor();
        TypeSymbol rawType = CommonUtil.getRawType(typeSymbol);
        rawType = rawType.typeKind() == TypeDescKind.ARRAY ? CommonUtil.getRawType(((ArrayTypeSymbol)rawType).memberTypeDescriptor()) : rawType;
        return rawType.typeKind() == TypeDescKind.MAP || rawType.typeKind() == TypeDescKind.RECORD;
    }

    private List<SnippetCompletionItem> getAnnotationAttachmentPoints(BallerinaCompletionContext context, AnnotationDeclarationNode node) {
        AttachmentPointContext attachmentPointContext = this.getAttachmentPointContext(context, node);
        ArrayList<Snippet> itemSnippets = new ArrayList<Snippet>();
        switch (attachmentPointContext.ordinal()) {
            case 0: {
                itemSnippets.addAll(this.anyAttachmentPoints());
                break;
            }
            case 1: {
                itemSnippets.addAll(this.dualAttachmentPoints());
                itemSnippets.addAll(this.sourceOnlyAttachmentPoints());
                break;
            }
            case 3: {
                itemSnippets.addAll(Arrays.asList(Snippet.KW_FUNCTION, Snippet.KW_FIELD));
                break;
            }
            case 6: {
                itemSnippets.add(Snippet.KW_FIELD);
                break;
            }
            case 5: {
                itemSnippets.add(Snippet.KW_FUNCTION);
                break;
            }
            case 4: {
                itemSnippets.addAll(Arrays.asList(Snippet.KW_REMOTE, Snippet.KW_REMOTE_FUNCTION));
                break;
            }
        }
        return itemSnippets.stream().map(snippet -> new SnippetCompletionItem(context, snippet.get())).toList();
    }

    private List<Snippet> anyAttachmentPoints() {
        return Arrays.asList(Snippet.KW_SOURCE, Snippet.KW_TYPE, Snippet.KW_CLASS, Snippet.KW_FUNCTION, Snippet.KW_OBJ_FUNCTION, Snippet.KW_SERVICE_REMOTE_FUNCTION, Snippet.KW_PARAMETER, Snippet.KW_RETURN, Snippet.KW_SERVICE, Snippet.KW_OBJECT, Snippet.KW_RECORD, Snippet.KW_OBJECT_FIELD, Snippet.KW_RECORD_FIELD, Snippet.KW_FIELD, Snippet.KW_SOURCE_ANNOTATION, Snippet.KW_SOURCE_EXTERNAL, Snippet.KW_SOURCE_VAR, Snippet.KW_SOURCE_CONST, Snippet.KW_SOURCE_LISTENER, Snippet.KW_SOURCE_WORKER, Snippet.KW_SOURCE_CLIENT);
    }

    private List<Snippet> dualAttachmentPoints() {
        return Arrays.asList(Snippet.KW_TYPE, Snippet.KW_CLASS, Snippet.KW_OBJ_FUNCTION, Snippet.KW_SERVICE_REMOTE_FUNCTION, Snippet.KW_PARAMETER, Snippet.KW_RETURN, Snippet.KW_SERVICE, Snippet.KW_OBJECT_FIELD, Snippet.KW_RECORD_FIELD, Snippet.KW_FIELD, Snippet.KW_FUNCTION);
    }

    private List<Snippet> sourceOnlyAttachmentPoints() {
        return Arrays.asList(Snippet.KW_ANNOTATION, Snippet.KW_EXTERNAL, Snippet.KW_VAR, Snippet.KW_CONST, Snippet.KW_LISTENER, Snippet.KW_WORKER, Snippet.KW_CLIENT);
    }

    private AttachmentPointContext getAttachmentPointContext(BallerinaCompletionContext context, AnnotationDeclarationNode node) {
        Optional sourceKeyword;
        SeparatedNodeList attachmentPoints = node.attachPoints();
        Optional<AnnotationAttachPointNode> attachmentPointAtCursor = this.attachmentPointAtCursor(context, (SeparatedNodeList<Node>)attachmentPoints);
        if (attachmentPointAtCursor.isEmpty()) {
            return AttachmentPointContext.ANY;
        }
        NodeList identifiers = attachmentPointAtCursor.get().identifiers();
        int cursor = context.getCursorPositionInTree();
        Optional<Object> immediatePreviousToken = Optional.empty();
        for (int i = identifiers.size() - 1; i >= 0; --i) {
            Token token = (Token)identifiers.get(i);
            if (token.isMissing() || cursor <= token.textRange().endOffset()) continue;
            immediatePreviousToken = Optional.of(token);
            break;
        }
        if ((sourceKeyword = attachmentPointAtCursor.get().sourceKeyword()).isPresent() && ((Token)sourceKeyword.get()).textRange().endOffset() < cursor && (immediatePreviousToken.isEmpty() || ((Token)immediatePreviousToken.get()).textRange().endOffset() > cursor)) {
            return AttachmentPointContext.SOURCE;
        }
        if (immediatePreviousToken.isEmpty()) {
            return AttachmentPointContext.ANY;
        }
        SyntaxKind immediatePreviousTokenKind = ((Token)immediatePreviousToken.get()).kind();
        if (immediatePreviousTokenKind == SyntaxKind.OBJECT_KEYWORD) {
            return AttachmentPointContext.OBJECT;
        }
        if (immediatePreviousTokenKind == SyntaxKind.SERVICE_KEYWORD) {
            return AttachmentPointContext.SERVICE;
        }
        if (immediatePreviousTokenKind == SyntaxKind.REMOTE_KEYWORD) {
            return AttachmentPointContext.REMOTE;
        }
        if (immediatePreviousTokenKind == SyntaxKind.RECORD_KEYWORD) {
            return AttachmentPointContext.RECORD;
        }
        return AttachmentPointContext.NONE;
    }

    private Optional<AnnotationAttachPointNode> attachmentPointAtCursor(BallerinaCompletionContext context, SeparatedNodeList<Node> nodes) {
        int nodeIndex;
        if (nodes.isEmpty()) {
            return Optional.empty();
        }
        int cursor = context.getCursorPositionInTree();
        int separatorIndex = -1;
        for (int i = nodes.separatorSize(); i > 0; --i) {
            Token separator = nodes.getSeparator(i - 1);
            if (separator.textRange().endOffset() > cursor) continue;
            separatorIndex = i - 1;
            break;
        }
        if ((nodeIndex = separatorIndex + 1) > nodes.size() || nodes.get(nodeIndex).isMissing()) {
            return Optional.empty();
        }
        return Optional.of((AnnotationAttachPointNode)nodes.get(nodeIndex));
    }

    private static enum AttachmentPointContext {
        ANY,
        SOURCE,
        DUAL,
        OBJECT,
        SERVICE,
        REMOTE,
        RECORD,
        NONE;

    }
}

