/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionException;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.SymbolCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.CompletionUtil;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class CheckExpressionNodeContext
extends AbstractCompletionProvider<CheckExpressionNode> {
    public CheckExpressionNodeContext() {
        super(CheckExpressionNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext ctx, CheckExpressionNode node) throws LSCompletionException {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (node.parent().kind() == SyntaxKind.ASSIGNMENT_STATEMENT || node.parent().kind() == SyntaxKind.LOCAL_VAR_DECL || node.parent().kind() == SyntaxKind.MODULE_VAR_DECL || node.parent().kind() == SyntaxKind.OBJECT_FIELD || node.parent().kind() == SyntaxKind.FROM_CLAUSE) {
            completionItems.addAll(CompletionUtil.route(ctx, (Node)node.parent()));
        } else {
            NonTerminalNode nodeAtCursor = ctx.getNodeAtCursor();
            if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)ctx, (Node)nodeAtCursor)) {
                List<Symbol> expressions = QNameRefCompletionUtil.getExpressionContextEntries(ctx, (QualifiedNameReferenceNode)nodeAtCursor);
                completionItems.addAll(this.getCompletionItemList(expressions, ctx));
            } else {
                completionItems.addAll(this.actionKWCompletions(ctx));
                completionItems.addAll(this.expressionCompletions(ctx));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(ctx, Snippet.STMT_COMMIT.get()));
            }
        }
        this.sort(ctx, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    @Override
    public void sort(BallerinaCompletionContext context, CheckExpressionNode node, List<LSCompletionItem> completionItems) {
        Optional contextType = context.getContextType();
        for (LSCompletionItem completionItem : completionItems) {
            Object sortText = null;
            LSCompletionItem.CompletionItemType type = completionItem.getType();
            if (type == LSCompletionItem.CompletionItemType.SYMBOL) {
                MethodSymbol methodSymbol;
                Optional<Symbol> symbol = ((SymbolCompletionItem)completionItem).getSymbol();
                if (symbol.isPresent() && symbol.get().kind() == SymbolKind.VARIABLE) {
                    if (SymbolUtil.isClient(symbol.get())) {
                        sortText = SortingUtil.genSortText(1);
                    } else if (SymbolUtil.isClassVariable(symbol.get())) {
                        sortText = SortingUtil.genSortText(3);
                    }
                } else if (symbol.isPresent() && symbol.get().kind() == SymbolKind.METHOD && (methodSymbol = (MethodSymbol)symbol.get()).nameEquals("init")) {
                    sortText = SortingUtil.genSortText(1);
                }
            } else if (type == LSCompletionItem.CompletionItemType.SNIPPET && ((SnippetCompletionItem)completionItem).id().equals(Snippet.KW_NEW.name())) {
                sortText = SortingUtil.genSortText(2);
            }
            if (sortText == null && contextType.isPresent() && SortingUtil.isCompletionItemAssignableWithCheck(completionItem, (TypeSymbol)contextType.get())) {
                sortText = SortingUtil.genSortText(3);
            }
            if (sortText == null) {
                sortText = SortingUtil.genSortText(4);
            }
            sortText = (String)sortText + SortingUtil.genSortText(SortingUtil.toRank(context, completionItem));
            completionItem.getCompletionItem().setSortText((String)sortText);
        }
    }
}

