/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.providers.context.util.ClassDefinitionNodeContextUtil;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;

public class ClassDefinitionNodeContext
extends AbstractCompletionProvider<ClassDefinitionNode> {
    public ClassDefinitionNodeContext() {
        super(ClassDefinitionNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, ClassDefinitionNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (this.withinBody(context, node)) {
            completionItems.addAll(this.getClassBodyCompletions(context, node));
        } else if (this.inQualifierContext(context, node)) {
            completionItems.addAll(this.getCompletionsInQualifierContext(context, node));
        }
        this.sort(context, node, completionItems);
        return completionItems;
    }

    private Collection<? extends LSCompletionItem> getCompletionsInQualifierContext(BallerinaCompletionContext context, ClassDefinitionNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        NodeList qualifiers = node.classTypeQualifiers();
        List<Token> qualifiersAtCursor = CommonUtil.getQualifiersAtCursor(context);
        if (qualifiers.isEmpty() || qualifiersAtCursor.isEmpty()) {
            this.checkAndAddCompletionItemsForQualifierKinds(completionItems, (NodeList<Token>)qualifiers, context);
            return completionItems;
        }
        Token lastQualifier = qualifiersAtCursor.get(qualifiersAtCursor.size() - 1);
        if (lastQualifier.kind() != SyntaxKind.SERVICE_KEYWORD && lastQualifier.kind() != SyntaxKind.CLIENT_KEYWORD) {
            this.checkAndAddCompletionItemsForQualifierKinds(completionItems, (NodeList<Token>)qualifiers, context);
            return completionItems;
        }
        return completionItems;
    }

    private void checkAndAddCompletionItemsForQualifierKinds(List<LSCompletionItem> completionItems, NodeList<Token> existingQualifiers, BallerinaCompletionContext context) {
        List<SyntaxKind> qualifierKinds = List.of(SyntaxKind.ISOLATED_KEYWORD, SyntaxKind.READONLY_KEYWORD, SyntaxKind.DISTINCT_KEYWORD, SyntaxKind.CLIENT_KEYWORD, SyntaxKind.SERVICE_KEYWORD);
        qualifierKinds.stream().filter(kind -> !this.isQualifierKindAvailable((SyntaxKind)kind, existingQualifiers)).forEach(qualifierKind -> {
            switch (qualifierKind) {
                case ISOLATED_KEYWORD: {
                    completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_ISOLATED.get()));
                    break;
                }
                case CLIENT_KEYWORD: {
                    if (this.isQualifierKindAvailable(SyntaxKind.SERVICE_KEYWORD, existingQualifiers)) break;
                    completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_CLIENT.get()));
                    break;
                }
                case SERVICE_KEYWORD: {
                    if (this.isQualifierKindAvailable(SyntaxKind.CLIENT_KEYWORD, existingQualifiers)) break;
                    completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_SERVICE.get()));
                    break;
                }
                case READONLY_KEYWORD: {
                    completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_READONLY.get()));
                    break;
                }
                case DISTINCT_KEYWORD: {
                    completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_DISTINCT.get()));
                    break;
                }
            }
        });
    }

    private boolean isQualifierKindAvailable(SyntaxKind qualifierKind, NodeList<Token> existingQualifiers) {
        return existingQualifiers.stream().anyMatch(token -> token.kind().equals((Object)qualifierKind));
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, ClassDefinitionNode node) {
        int cursor = context.getCursorPositionInTree();
        Token classKeyword = node.classKeyword();
        if (this.withinBody(context, node)) {
            return true;
        }
        if (classKeyword.isMissing() || cursor > node.closeBrace().textRange().startOffset()) {
            return false;
        }
        return this.inQualifierContext(context, node) || cursor > classKeyword.textRange().endOffset();
    }

    private boolean withinBody(BallerinaCompletionContext context, ClassDefinitionNode node) {
        int cursor = context.getCursorPositionInTree();
        Token openBrace = node.openBrace();
        Token closeBrace = node.closeBrace();
        if (openBrace.isMissing() || closeBrace.isMissing()) {
            return false;
        }
        return cursor >= openBrace.textRange().endOffset() && cursor <= closeBrace.textRange().startOffset();
    }

    private boolean inQualifierContext(BallerinaCompletionContext context, ClassDefinitionNode node) {
        Optional visibilityQualifier = node.visibilityQualifier();
        int cursor = context.getCursorPositionInTree();
        return visibilityQualifier.isPresent() && cursor >= ((Token)visibilityQualifier.get()).textRange().startOffset() && cursor <= node.classKeyword().textRange().startOffset();
    }

    private List<LSCompletionItem> getClassBodyCompletions(BallerinaCompletionContext context, ClassDefinitionNode node) {
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            List<Symbol> typesInModule = QNameRefCompletionUtil.getTypesInModule(context, qNameRef);
            return this.getCompletionItemList(typesInModule, context);
        }
        if (this.onSuggestionsAfterQualifiers(context, (Node)context.getNodeAtCursor())) {
            return this.getCompletionItemsOnQualifiers((Node)context.getNodeAtCursor(), context);
        }
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_PRIVATE.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_PUBLIC.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_FINAL.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_REMOTE.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_RESOURCE.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_REMOTE_FUNCTION.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_FUNCTION.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_ISOLATED.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_TRANSACTIONAL.get()));
        completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_RESOURCE_FUNCTION_SIGNATURE.get()));
        if (ClassDefinitionNodeContextUtil.onSuggestInitFunction((Node)node)) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_INIT_FUNCTION.get()));
        }
        completionItems.addAll(this.getTypeDescContextItems(context));
        return completionItems;
    }

    @Override
    protected List<LSCompletionItem> getCompletionItemsOnQualifiers(Node node, BallerinaCompletionContext context) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>(super.getCompletionItemsOnQualifiers(node, context));
        List<Token> qualifiers = CommonUtil.getQualifiersOfNode(context, node);
        if (qualifiers.isEmpty()) {
            return completionItems;
        }
        Token lastQualifier = qualifiers.get(qualifiers.size() - 1);
        if (lastQualifier.kind() == SyntaxKind.ISOLATED_KEYWORD || lastQualifier.kind() == SyntaxKind.TRANSACTIONAL_KEYWORD) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_REMOTE.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_RESOURCE.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_REMOTE_FUNCTION.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_FUNCTION.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_RESOURCE_FUNCTION_SIGNATURE.get()));
        } else if (lastQualifier.kind() == SyntaxKind.PRIVATE_KEYWORD || lastQualifier.kind() == SyntaxKind.PUBLIC_KEYWORD) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_FINAL.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_REMOTE.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_RESOURCE.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_REMOTE_FUNCTION.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_FUNCTION.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_ISOLATED.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_TRANSACTIONAL.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_RESOURCE_FUNCTION_SIGNATURE.get()));
            if (ClassDefinitionNodeContextUtil.onSuggestInitFunction(node)) {
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_INIT_FUNCTION.get()));
            }
            completionItems.addAll(this.getTypeDescContextItems(context));
        }
        return completionItems;
    }
}

