/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.ConditionalExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class ConditionalExpressionNodeContext
extends AbstractCompletionProvider<ConditionalExpressionNode> {
    public ConditionalExpressionNodeContext() {
        super(ConditionalExpressionNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, ConditionalExpressionNode node) {
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (this.isMiddleExpressionQNameRef(node)) {
            String middleExprName = ((SimpleNameReferenceNode)node.middleExpression()).name().text();
            List<Symbol> expressionContextSymbols = QNameRefCompletionUtil.getExpressionContextEntries(context, middleExprName);
            if (expressionContextSymbols.isEmpty()) {
                completionItems.addAll(this.expressionCompletions(context));
            } else {
                completionItems.addAll(this.getCompletionItemList(expressionContextSymbols, context));
            }
        } else if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
            List<Symbol> expressionContextSymbols = QNameRefCompletionUtil.getExpressionContextEntries(context, (QualifiedNameReferenceNode)nodeAtCursor);
            completionItems.addAll(this.getCompletionItemList(expressionContextSymbols, context));
        } else {
            completionItems.addAll(this.expressionCompletions(context));
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    private boolean isMiddleExpressionQNameRef(ConditionalExpressionNode node) {
        ExpressionNode middleExpression = node.middleExpression();
        ExpressionNode endExpression = node.endExpression();
        return !middleExpression.isMissing() && middleExpression.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE && !endExpression.isMissing() && endExpression.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE;
    }

    @Override
    public void sort(BallerinaCompletionContext context, ConditionalExpressionNode node, List<LSCompletionItem> completionItems) {
        Optional typeSymbolAtCursor = context.getContextType();
        if (typeSymbolAtCursor.isEmpty()) {
            super.sort(context, node, completionItems);
            return;
        }
        TypeSymbol symbol = (TypeSymbol)typeSymbolAtCursor.get();
        for (LSCompletionItem completionItem : completionItems) {
            completionItem.getCompletionItem().setSortText(SortingUtil.genSortTextByAssignability(context, completionItem, symbol));
        }
    }
}

