/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.syntax.tree.ConstantDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.context.NodeWithRHSInitializerProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public class ConstantDeclarationNodeContext
extends NodeWithRHSInitializerProvider<ConstantDeclarationNode> {
    public ConstantDeclarationNodeContext() {
        super(ConstantDeclarationNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, ConstantDeclarationNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        ResolvedContext resolvedContext = ResolvedContext.NONE;
        if (this.onTypeDescContext(context, node)) {
            if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
                QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
                List<Symbol> typesInModule = QNameRefCompletionUtil.getTypesInModule(context, qNameRef);
                completionItems.addAll(this.getCompletionItemList(typesInModule, context));
            } else {
                completionItems.addAll(this.getTypeDescContextItems(context));
                completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_ANNOTATION.get()));
            }
            resolvedContext = ResolvedContext.TYPEDESC;
        } else if (this.onExpressionContext(context, node)) {
            completionItems.addAll(this.initializerContextCompletions(context, node.initializer()));
            resolvedContext = ResolvedContext.EXPRESSION;
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems, new Object[]{resolvedContext});
        return completionItems;
    }

    @Override
    public void sort(BallerinaCompletionContext context, ConstantDeclarationNode node, List<LSCompletionItem> completionItems, Object ... metaData) {
        ResolvedContext resolvedContext = (ResolvedContext)((Object)metaData[0]);
        switch (resolvedContext.ordinal()) {
            case 1: {
                completionItems.forEach(lsCItem -> {
                    String sortText = SortingUtil.genSortTextForTypeDescContext(context, lsCItem);
                    lsCItem.getCompletionItem().setSortText(sortText);
                });
                break;
            }
            case 0: {
                super.sort(context, node, completionItems);
                break;
            }
        }
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, ConstantDeclarationNode node) {
        int cursor = context.getCursorPositionInTree();
        Token constKeyword = node.constKeyword();
        return !constKeyword.isMissing() && cursor > constKeyword.textRange().endOffset() && cursor <= node.semicolonToken().textRange().endOffset();
    }

    @Override
    protected List<LSCompletionItem> initializerContextCompletions(BallerinaCompletionContext context, Node initializer) {
        List<Symbol> constants;
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        Predicate<Symbol> predicate = symbol -> symbol.kind() == SymbolKind.CONSTANT || symbol.kind() == SymbolKind.ENUM_MEMBER;
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            constants = QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)context, qNameRef, predicate);
        } else {
            constants = context.visibleSymbols(context.getCursorPosition()).stream().filter(predicate).toList();
            completionItems.addAll(this.getModuleCompletionItems(context));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_TRUE.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_FALSE.get()));
        }
        completionItems.addAll(this.getCompletionItemList(constants, context));
        return completionItems;
    }

    private boolean onExpressionContext(BallerinaCompletionContext context, ConstantDeclarationNode node) {
        int cursor = context.getCursorPositionInTree();
        Token equalsToken = node.equalsToken();
        return !equalsToken.isMissing() && cursor > equalsToken.textRange().startOffset();
    }

    private boolean onTypeDescContext(BallerinaCompletionContext context, ConstantDeclarationNode node) {
        int cursor = context.getCursorPositionInTree();
        Token constKeyword = node.constKeyword();
        Token variableName = node.variableName();
        Optional tDesc = node.typeDescriptor();
        if (cursor < constKeyword.textRange().endOffset() + 1) {
            return false;
        }
        if (tDesc.isPresent()) {
            return cursor <= ((TypeDescriptorNode)tDesc.get()).textRange().endOffset();
        }
        if (!variableName.isMissing()) {
            return cursor <= variableName.textRange().endOffset();
        }
        return true;
    }

    static enum ResolvedContext {
        EXPRESSION,
        TYPEDESC,
        NONE;

    }
}

