/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.syntax.tree.ExplicitAnonymousFunctionExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionException;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.CompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;

public class ExplicitAnonymousFunctionExpressionNodeContext
extends AbstractCompletionProvider<ExplicitAnonymousFunctionExpressionNode> {
    public ExplicitAnonymousFunctionExpressionNodeContext() {
        super(ExplicitAnonymousFunctionExpressionNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, ExplicitAnonymousFunctionExpressionNode node) throws LSCompletionException {
        if (this.onSuggestionsAfterQualifiers(context, node)) {
            return Collections.singletonList(new SnippetCompletionItem(context, Snippet.KW_FUNCTION.get()));
        }
        if (this.onSuggestionsWithinSignature(context, node)) {
            return CompletionUtil.route(context, (Node)node.functionSignature());
        }
        return new ArrayList<LSCompletionItem>();
    }

    private boolean onSuggestionsAfterQualifiers(BallerinaCompletionContext context, ExplicitAnonymousFunctionExpressionNode node) {
        int cursor = context.getCursorPositionInTree();
        NodeList qualifiers = node.qualifierList();
        Token functionKeyword = node.functionKeyword();
        if (qualifiers.isEmpty()) {
            return false;
        }
        Token lastQualifier = (Token)qualifiers.get(qualifiers.size() - 1);
        return cursor > lastQualifier.textRange().endOffset() && (functionKeyword.isMissing() || cursor < functionKeyword.textRange().startOffset());
    }

    private boolean onSuggestionsWithinSignature(BallerinaCompletionContext context, ExplicitAnonymousFunctionExpressionNode node) {
        Token functionKeyword = node.functionKeyword();
        if (functionKeyword.isMissing()) {
            return false;
        }
        Token openParenToken = node.functionSignature().openParenToken();
        int cursor = context.getCursorPositionInTree();
        return !openParenToken.isMissing() && openParenToken.textRange().endOffset() <= cursor;
    }
}

