/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.Document;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.StaticCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.FieldAccessCompletionResolver;
import org.ballerinalang.langserver.completions.util.ForeachCompletionUtil;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.TypeGuardCompletionUtil;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextEdit;

public abstract class FieldAccessContext<T extends Node>
extends AbstractCompletionProvider<T> {
    public FieldAccessContext(Class<T> attachmentPoint) {
        super(attachmentPoint);
    }

    protected List<LSCompletionItem> getEntries(BallerinaCompletionContext ctx, ExpressionNode expr) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        FieldAccessCompletionResolver resolver = new FieldAccessCompletionResolver((PositionedOperationContext)ctx);
        Optional<TypeSymbol> typeSymbol = resolver.getTypeSymbol((Node)expr);
        if (typeSymbol.isEmpty()) {
            return completionItems;
        }
        TypeSymbol rawType = CommonUtil.getRawType(typeSymbol.get());
        if (rawType.typeKind() == TypeDescKind.XML) {
            completionItems.addAll(this.getXmlAttributeAccessCompletions(ctx));
        }
        if (!QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)ctx, (Node)ctx.getNodeAtCursor())) {
            List<Symbol> symbolList = resolver.getVisibleEntries((Node)expr);
            if (expr.parent().kind() == SyntaxKind.FIELD_ACCESS) {
                FieldAccessExpressionNode fieldAccessExpr = (FieldAccessExpressionNode)expr.parent();
                completionItems.addAll(TypeGuardCompletionUtil.getTypeGuardDestructedItems(ctx, fieldAccessExpr, typeSymbol.get()));
                completionItems.addAll(ForeachCompletionUtil.getForeachCompletionItemsForIterable(ctx, fieldAccessExpr, typeSymbol.get()));
            }
            completionItems.addAll(this.getCompletionItemList(symbolList, ctx));
        }
        if (this.isMemberAccessAllowed(rawType, (Node)expr.parent())) {
            completionItems.add(this.getMemberAccessCompletionItem(ctx, (FieldAccessExpressionNode)expr.parent()));
        }
        return completionItems;
    }

    @Override
    public abstract void sort(BallerinaCompletionContext var1, T var2, List<LSCompletionItem> var3);

    private boolean isMemberAccessAllowed(TypeSymbol typeSymbol, Node parentNode) {
        return parentNode.kind() == SyntaxKind.FIELD_ACCESS && (typeSymbol.typeKind() == TypeDescKind.MAP || typeSymbol.typeKind() == TypeDescKind.RECORD && ((RecordTypeSymbol)typeSymbol).restTypeDescriptor().isPresent());
    }

    private List<LSCompletionItem> getXmlAttributeAccessCompletions(BallerinaCompletionContext context) {
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)context.getNodeAtCursor())) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)context.getNodeAtCursor();
            Predicate<Symbol> predicate = symbol -> symbol.kind() == SymbolKind.CONSTANT && CommonUtil.getRawType(((ConstantSymbol)symbol).broaderTypeDescriptor()).typeKind() == TypeDescKind.STRING;
            List<Symbol> moduleContent = QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)context, qNameRef, predicate);
            return this.getCompletionItemList(moduleContent, context);
        }
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        List<Symbol> xmlNamespaces = context.visibleSymbols(context.getCursorPosition()).stream().filter(symbol -> symbol.kind() == SymbolKind.XMLNS).toList();
        completionItems.addAll(this.getCompletionItemList(xmlNamespaces, context));
        completionItems.addAll(this.getModuleCompletionItems(context));
        return completionItems;
    }

    private LSCompletionItem getMemberAccessCompletionItem(BallerinaCompletionContext context, FieldAccessExpressionNode faNode) {
        String insertText = "[\"${1}\"]";
        int dotStart = faNode.dotToken().textRange().startOffset();
        int dotEnd = faNode.dotToken().textRange().endOffset();
        Range range = PositionUtil.toRange(dotStart, dotEnd, ((Document)context.currentDocument().get()).textDocument());
        TextEdit textEdit = new TextEdit();
        textEdit.setNewText("");
        textEdit.setRange(range);
        CompletionItem completionItem = new CompletionItem();
        completionItem.setInsertText(insertText);
        completionItem.setKind(CompletionItemKind.Snippet);
        completionItem.setDocumentation("Convert to a member access expression");
        completionItem.setLabel("[\"\"]");
        completionItem.setAdditionalTextEdits(Collections.singletonList(textEdit));
        completionItem.setInsertTextFormat(InsertTextFormat.Snippet);
        return new StaticCompletionItem(context, completionItem, StaticCompletionItem.Kind.OTHER);
    }
}

