/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.ForEachStatementNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.tools.text.LinePosition;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.eclipse.lsp4j.Position;

public class ForEachStatementNodeContext
extends AbstractCompletionProvider<ForEachStatementNode> {
    public ForEachStatementNodeContext() {
        super(ForEachStatementNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, ForEachStatementNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (this.withinTypeDescContext(context, node)) {
            completionItems.addAll(this.getTypeDescContextItems(context));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_VAR.get()));
        } else if (node.inKeyword().isMissing()) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_IN.get()));
        } else if (this.withinActionOrExpressionContext(context, node)) {
            completionItems.addAll(this.actionKWCompletions(context));
            completionItems.addAll(this.expressionCompletions(context));
        }
        this.sort(context, node, completionItems);
        return completionItems;
    }

    private boolean withinTypeDescContext(BallerinaCompletionContext context, ForEachStatementNode node) {
        TypedBindingPatternNode typedBindingPatternNode = node.typedBindingPattern();
        if (typedBindingPatternNode.isMissing() || typedBindingPatternNode.typeDescriptor().isMissing()) {
            return false;
        }
        TypeDescriptorNode typeDescriptorNode = typedBindingPatternNode.typeDescriptor();
        LinePosition typeDescEnd = typeDescriptorNode.lineRange().endLine();
        Position cursor = context.getCursorPosition();
        return cursor.getLine() < typeDescEnd.line() || cursor.getLine() == typeDescEnd.line() && cursor.getCharacter() <= typeDescEnd.offset();
    }

    private boolean withinActionOrExpressionContext(BallerinaCompletionContext context, ForEachStatementNode node) {
        Token inKeyword = node.inKeyword();
        if (inKeyword.isMissing()) {
            return false;
        }
        LinePosition inKWEnd = inKeyword.lineRange().endLine();
        Position cursor = context.getCursorPosition();
        return cursor.getLine() < inKWEnd.line() || cursor.getLine() == inKWEnd.line() && cursor.getCharacter() > inKWEnd.offset();
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, ForEachStatementNode node) {
        int cursor = context.getCursorPositionInTree();
        Token matchKeyword = node.forEachKeyword();
        BlockStatementNode blockStatement = node.blockStatement();
        return !matchKeyword.isMissing() && cursor >= matchKeyword.textRange().endOffset() + 1 && (blockStatement.isMissing() || cursor < blockStatement.openBraceToken().textRange().endOffset());
    }
}

