/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.context.InvocationNodeContextProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;

public class FunctionCallExpressionNodeContext
extends InvocationNodeContextProvider<FunctionCallExpressionNode> {
    public FunctionCallExpressionNodeContext() {
        super(FunctionCallExpressionNode.class);
    }

    @Override
    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext ctx, FunctionCallExpressionNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)ctx, (Node)ctx.getNodeAtCursor())) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)ctx.getNodeAtCursor();
            completionItems.addAll(this.getCompletionItemList(QNameRefCompletionUtil.getExpressionContextEntries(ctx, qNameRef), ctx));
        } else {
            if (this.isNotInNamedArgOnlyContext(ctx, node.arguments().stream().toList())) {
                completionItems.addAll(this.actionKWCompletions(ctx));
                completionItems.addAll(this.expressionCompletions(ctx));
            }
            completionItems.addAll(this.getNamedArgExpressionCompletionItems(ctx, node));
        }
        this.sort(ctx, node, completionItems);
        return completionItems;
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, FunctionCallExpressionNode node) {
        int cursor = context.getCursorPositionInTree();
        Token openParen = node.openParenToken();
        Token closeParen = node.closeParenToken();
        return cursor > openParen.textRange().startOffset() && cursor < closeParen.textRange().endOffset();
    }

    private List<LSCompletionItem> getNamedArgExpressionCompletionItems(BallerinaCompletionContext context, FunctionCallExpressionNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        Optional semanticModel = context.currentSemanticModel();
        if (semanticModel.isEmpty()) {
            return completionItems;
        }
        Optional symbol = ((SemanticModel)semanticModel.get()).symbol((Node)node);
        if (symbol.isEmpty() || ((Symbol)symbol.get()).kind() != SymbolKind.FUNCTION && ((Symbol)symbol.get()).kind() != SymbolKind.METHOD && ((Symbol)symbol.get()).kind() != SymbolKind.RESOURCE_METHOD) {
            return completionItems;
        }
        FunctionSymbol functionSymbol = (FunctionSymbol)symbol.get();
        return this.getNamedArgCompletionItems(context, functionSymbol, (SeparatedNodeList<FunctionArgumentNode>)node.arguments());
    }
}

