/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.LinePosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.context.InvocationNodeContextProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;

public class ImplicitNewExpressionNodeContext
extends InvocationNodeContextProvider<ImplicitNewExpressionNode> {
    public ImplicitNewExpressionNodeContext() {
        super(ImplicitNewExpressionNode.class);
    }

    @Override
    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, ImplicitNewExpressionNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        if (this.withinArgs(context, node)) {
            completionItems.addAll(this.getCompletionsWithinArgs(context, node));
        } else {
            List<Symbol> filteredSymbols = context.visibleSymbols(context.getCursorPosition()).stream().filter(this.getSymbolFilterPredicate((Node)node)).toList();
            filteredSymbols.forEach(symbol -> {
                Optional<LSCompletionItem> cItem = this.getExplicitNewCompletionItem((Symbol)symbol, context);
                cItem.ifPresent(completionItems::add);
            });
            completionItems.addAll(this.getModuleCompletionItems(context));
        }
        this.sort(context, node, completionItems);
        return completionItems;
    }

    private Predicate<Symbol> getSymbolFilterPredicate(Node node) {
        if (node.parent().kind() == SyntaxKind.SERVICE_DECLARATION || node.parent().kind() == SyntaxKind.LISTENER_DECLARATION) {
            return symbol -> symbol.kind() == SymbolKind.CLASS && SymbolUtil.isListener(symbol);
        }
        return symbol -> symbol.kind() == SymbolKind.CLASS || symbol.kind() == SymbolKind.TYPE_DEFINITION && ((TypeDefinitionSymbol)symbol).typeDescriptor().typeKind() == TypeDescKind.STREAM;
    }

    private boolean withinArgs(BallerinaCompletionContext context, ImplicitNewExpressionNode node) {
        if (node.parenthesizedArgList().isEmpty()) {
            return false;
        }
        ParenthesizedArgList parenthesizedArgList = (ParenthesizedArgList)node.parenthesizedArgList().get();
        int cursor = context.getCursorPositionInTree();
        return cursor > parenthesizedArgList.openParenToken().textRange().startOffset() && cursor < parenthesizedArgList.closeParenToken().textRange().endOffset();
    }

    private List<LSCompletionItem> getCompletionsWithinArgs(BallerinaCompletionContext ctx, ImplicitNewExpressionNode node) {
        List arguments;
        NonTerminalNode nodeAtCursor = ctx.getNodeAtCursor();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)ctx, (Node)nodeAtCursor)) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            return this.getCompletionItemList(QNameRefCompletionUtil.getExpressionContextEntries(ctx, qNameRef), ctx);
        }
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        List list = arguments = node.parenthesizedArgList().isPresent() ? ((ParenthesizedArgList)node.parenthesizedArgList().get()).arguments().stream().toList() : Collections.emptyList();
        if (this.isNotInNamedArgOnlyContext(ctx, arguments)) {
            completionItems.addAll(this.expressionCompletions(ctx));
        }
        completionItems.addAll(this.getNamedArgExpressionCompletionItems(ctx, node));
        return completionItems;
    }

    private List<LSCompletionItem> getNamedArgExpressionCompletionItems(BallerinaCompletionContext context, ImplicitNewExpressionNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        Optional type = Optional.empty();
        if (context.currentSemanticModel().isPresent() && context.currentDocument().isPresent()) {
            LinePosition linePosition = node.parent().location().lineRange().startLine();
            type = ((SemanticModel)context.currentSemanticModel().get()).expectedType((Document)context.currentDocument().get(), linePosition);
        }
        if (type.isEmpty()) {
            return completionItems;
        }
        TypeSymbol typeSymbol = CommonUtil.getRawType((TypeSymbol)type.get());
        if (typeSymbol.kind() != SymbolKind.CLASS) {
            return completionItems;
        }
        Optional methodSymbol = ((ClassSymbol)typeSymbol).initMethod();
        if (methodSymbol.isEmpty() || node.parenthesizedArgList().isEmpty()) {
            return completionItems;
        }
        completionItems.addAll(this.getNamedArgCompletionItems(context, (FunctionSymbol)methodSymbol.get(), (SeparatedNodeList<FunctionArgumentNode>)((ParenthesizedArgList)node.parenthesizedArgList().get()).arguments()));
        return completionItems;
    }
}

