/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.langserver.LSPackageLoader;
import org.ballerinalang.langserver.common.utils.ModuleUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.CompletionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.providers.context.util.ImportDeclarationContextUtil;
import org.ballerinalang.langserver.completions.util.SortingUtil;
import org.wso2.ballerinalang.compiler.util.Names;

public class ImportOrgNameNodeContext
extends AbstractCompletionProvider<ImportOrgNameNode> {
    public ImportOrgNameNodeContext() {
        super(ImportOrgNameNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext ctx, ImportOrgNameNode node) {
        String orgName = node.orgName().text();
        if (orgName.isEmpty()) {
            throw new AssertionError((Object)"ModuleName cannot be empty");
        }
        List<LSPackageLoader.ModuleInfo> packages = orgName.equals("ballerinax") ? LSPackageLoader.getInstance(ctx.languageServercontext()).getCentralPackages() : LSPackageLoader.getInstance(ctx.languageServercontext()).getAllVisiblePackages((DocumentServiceContext)ctx);
        ArrayList<LSCompletionItem> completionItems = this.moduleNameContextCompletions(ctx, orgName, packages);
        this.sort(ctx, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    private ArrayList<LSCompletionItem> moduleNameContextCompletions(BallerinaCompletionContext context, String orgName, List<LSPackageLoader.ModuleInfo> moduleList) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        ArrayList pkgNameLabels = new ArrayList();
        moduleList.forEach(ballerinaPackage -> {
            String packageName = ballerinaPackage.packageName();
            if (orgName.equals(ballerinaPackage.packageOrg()) && !pkgNameLabels.contains(packageName) && ModuleUtil.matchingImportedModule((CompletionContext)context, ballerinaPackage).isEmpty()) {
                String insertText = orgName.equals(Names.BALLERINA_ORG.value) && packageName.startsWith(Names.LANG.value + ".") ? ImportDeclarationContextUtil.getLangLibModuleNameInsertText(packageName) : packageName;
                pkgNameLabels.add(packageName);
                completionItems.add(ImportDeclarationContextUtil.getImportCompletion(context, packageName, insertText));
            }
        });
        return completionItems;
    }

    @Override
    public void sort(BallerinaCompletionContext context, ImportOrgNameNode node, List<LSCompletionItem> compItems) {
        String orgName = node.orgName().text();
        if (!"ballerina".equals(orgName)) {
            return;
        }
        compItems.forEach(item -> {
            int rank = item.getCompletionItem().getLabel().startsWith("lang.") ? 2 : 1;
            item.getCompletionItem().setSortText(SortingUtil.genSortText(rank));
        });
    }
}

