/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.Document;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.NameUtil;
import org.ballerinalang.langserver.common.utils.PositionUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.DocumentServiceContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SpreadCompletionItem;
import org.ballerinalang.langserver.completions.builder.SpreadCompletionItemBuilder;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.SortingUtil;
import org.eclipse.lsp4j.CompletionItem;

public class ListConstructorExpressionNodeContext
extends AbstractCompletionProvider<ListConstructorExpressionNode> {
    public ListConstructorExpressionNodeContext() {
        super(ListConstructorExpressionNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, ListConstructorExpressionNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
            List<Symbol> entries = QNameRefCompletionUtil.getExpressionContextEntries(context, (QualifiedNameReferenceNode)nodeAtCursor);
            completionItems.addAll(this.getCompletionItemList(entries, context));
        } else {
            completionItems.addAll(this.expressionCompletions(context));
            if (context.getNodeAtCursor().kind() != SyntaxKind.SPREAD_MEMBER) {
                completionItems.addAll(this.spreadOperatorCompletions(context));
            }
        }
        this.sort(context, node, (List<LSCompletionItem>)completionItems);
        return completionItems;
    }

    private List<SpreadCompletionItem> spreadOperatorCompletions(BallerinaCompletionContext context) {
        Optional semanticModel = context.currentSemanticModel();
        Optional document = context.currentDocument();
        if (semanticModel.isEmpty() || document.isEmpty()) {
            return Collections.emptyList();
        }
        Optional expectedType = ((SemanticModel)semanticModel.get()).expectedType((Document)document.get(), PositionUtil.getLinePosition(context.getCursorPosition()));
        if (expectedType.isEmpty()) {
            return Collections.emptyList();
        }
        return context.visibleSymbols(context.getCursorPosition()).stream().filter(symbol -> {
            TypeSymbol typeDescriptor;
            if (symbol.getName().isEmpty()) {
                return false;
            }
            if (symbol.kind() == SymbolKind.VARIABLE) {
                typeDescriptor = ((VariableSymbol)symbol).typeDescriptor();
                if (typeDescriptor.typeKind() != TypeDescKind.ARRAY) {
                    return false;
                }
            } else if (symbol.kind() == SymbolKind.FUNCTION) {
                Optional typeSymbol = ((FunctionSymbol)symbol).typeDescriptor().returnTypeDescriptor();
                if (typeSymbol.isEmpty()) {
                    return false;
                }
                typeDescriptor = (TypeSymbol)typeSymbol.get();
            } else {
                return false;
            }
            return typeDescriptor.typeKind() == TypeDescKind.ARRAY && ((ArrayTypeSymbol)typeDescriptor).memberTypeDescriptor().subtypeOf((TypeSymbol)expectedType.get());
        }).map(symbol -> {
            TypeSymbol typeDescriptor = symbol.kind() == SymbolKind.VARIABLE ? ((VariableSymbol)symbol).typeDescriptor() : (TypeSymbol)((FunctionSymbol)symbol).typeDescriptor().returnTypeDescriptor().get();
            String typeName = NameUtil.getModifiedTypeName((DocumentServiceContext)context, typeDescriptor);
            CompletionItem completionItem = SpreadCompletionItemBuilder.build(symbol, typeName, context);
            return new SpreadCompletionItem(context, completionItem, (Symbol)symbol);
        }).toList();
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, ListConstructorExpressionNode node) {
        return node.textRange().startOffset() <= context.getCursorPositionInTree() && context.getCursorPositionInTree() <= node.textRange().endOffset();
    }

    @Override
    public void sort(BallerinaCompletionContext context, ListConstructorExpressionNode node, List<LSCompletionItem> completionItems) {
        for (LSCompletionItem lsCItem : completionItems) {
            Object sortText;
            Optional contextType = context.getContextType();
            if (contextType.isEmpty()) {
                sortText = SortingUtil.genSortText(SortingUtil.toRank(context, lsCItem, 2));
            } else if (lsCItem.getType() == LSCompletionItem.CompletionItemType.SPREAD) {
                Optional<Symbol> expression = ((SpreadCompletionItem)lsCItem).getExpression();
                int lastRank = expression.map(expr -> expr.kind() == SymbolKind.FUNCTION ? 4 : 3).orElse(3);
                sortText = SortingUtil.genSortText(1) + SortingUtil.genSortText(1) + SortingUtil.genSortText(lastRank);
            } else {
                sortText = !SortingUtil.isTypeCompletionItem(lsCItem) ? SortingUtil.genSortText(1) + SortingUtil.genSortTextByAssignability(context, lsCItem, (TypeSymbol)contextType.get()) + SortingUtil.genSortText(SortingUtil.toRank(context, lsCItem)) : SortingUtil.genSortText(2) + SortingUtil.genSortText(SortingUtil.toRank(context, lsCItem));
            }
            lsCItem.getCompletionItem().setSortText((String)sortText);
        }
    }
}

