/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.tools.text.LineRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.ballerinalang.langserver.common.utils.ModuleUtil;
import org.ballerinalang.langserver.common.utils.SymbolUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.SymbolCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.SortingUtil;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Position;

public class ListenerDeclarationNodeContext
extends AbstractCompletionProvider<ListenerDeclarationNode> {
    private static final String INIT_METHOD_NAME = "init";

    public ListenerDeclarationNodeContext() {
        super(ListenerDeclarationNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, ListenerDeclarationNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        Optional<ListenerDeclarationNode> listenerNode = this.listenerNode(context);
        if (listenerNode.isEmpty()) {
            return completionItems;
        }
        if (this.withinTypeDescContext(context, listenerNode.get())) {
            completionItems.addAll(this.typeDescriptorContextItems(context));
            this.sort(context, node, (List<LSCompletionItem>)completionItems, new Object[]{ContextScope.TYPE_DESC});
        } else if (this.withinInitializerContext(context, listenerNode.get())) {
            completionItems.addAll(this.expressionCompletions(context, listenerNode.get()));
            this.sort(context, node, (List<LSCompletionItem>)completionItems, new Object[]{ContextScope.INITIALIZER});
        }
        return completionItems;
    }

    @Override
    public void sort(BallerinaCompletionContext context, ListenerDeclarationNode node, List<LSCompletionItem> cmpItems, Object ... metaData) {
        ContextScope scope;
        super.sort(context, node, cmpItems, metaData);
        if (metaData.length < 1 || !(metaData[0] instanceof ContextScope)) {
            super.sort(context, node, cmpItems);
        }
        if ((scope = (ContextScope)((Object)metaData[0])) == ContextScope.TYPE_DESC) {
            for (LSCompletionItem lsItem : cmpItems) {
                CompletionItem cItem = lsItem.getCompletionItem();
                Object sortText = SortingUtil.isTypeCompletionItem(lsItem) ? SortingUtil.genSortText(1) : (SortingUtil.isModuleCompletionItem(lsItem) && !SortingUtil.isLangLibModuleCompletionItem(lsItem) ? SortingUtil.genSortText(2) + SortingUtil.genSortTextForModule(context, lsItem) : SortingUtil.genSortText(3));
                cItem.setSortText((String)sortText);
            }
            return;
        }
        if (scope == ContextScope.INITIALIZER) {
            Optional ctxType = context.getContextType();
            for (LSCompletionItem lsItem : cmpItems) {
                CompletionItem cItem = lsItem.getCompletionItem();
                int rank = -1;
                if (this.isValidSymbolCompletionItem(lsItem)) {
                    FunctionTypeSymbol functionTypeSymbol;
                    Optional typeSymbol;
                    SymbolCompletionItem symbolCItem = (SymbolCompletionItem)lsItem;
                    Symbol symbol = symbolCItem.getSymbol().get();
                    if (symbol.kind() == SymbolKind.VARIABLE && ctxType.isPresent() && SymbolUtil.getTypeDescriptor(symbol).get().subtypeOf((TypeSymbol)ctxType.get())) {
                        rank = 1;
                    } else if (symbol.kind() == SymbolKind.VARIABLE && ((VariableSymbol)symbol).qualifiers().contains(Qualifier.LISTENER)) {
                        rank = 2;
                    } else if (symbol.kind() == SymbolKind.METHOD && ((String)symbol.getName().get()).equals(INIT_METHOD_NAME)) {
                        rank = 3;
                    } else if (symbol.kind() == SymbolKind.FUNCTION && ctxType.isPresent() && (typeSymbol = (functionTypeSymbol = ((FunctionSymbol)symbol).typeDescriptor()).returnTypeDescriptor()).isPresent() && ((TypeSymbol)typeSymbol.get()).subtypeOf((TypeSymbol)ctxType.get())) {
                        rank = 4;
                    }
                } else if (Snippet.KW_NEW.equals(lsItem)) {
                    rank = 5;
                }
                rank = rank < 0 ? SortingUtil.toRank(context, lsItem, 5) : rank;
                cItem.setSortText(SortingUtil.genSortText(rank));
            }
        }
    }

    @Override
    public boolean onPreValidation(BallerinaCompletionContext context, ListenerDeclarationNode node) {
        int cursor = context.getCursorPositionInTree();
        Token listenerKeyword = node.listenerKeyword();
        return !listenerKeyword.isMissing() && listenerKeyword.textRange().endOffset() + 1 <= cursor && cursor <= node.semicolonToken().textRange().endOffset();
    }

    private List<LSCompletionItem> typeDescriptorContextItems(BallerinaCompletionContext context) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
            String modulePrefix = QNameRefCompletionUtil.getAlias((QualifiedNameReferenceNode)nodeAtCursor);
            completionItems.addAll(this.listenersInModule(context, modulePrefix));
        } else {
            completionItems.addAll(this.listenersAndPackagesItems(context));
        }
        return completionItems;
    }

    private List<LSCompletionItem> listenersAndPackagesItems(BallerinaCompletionContext context) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>(this.getModuleCompletionItems(context));
        List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
        List<Symbol> listeners = visibleSymbols.stream().filter(SymbolUtil::isListener).toList();
        completionItems.addAll(this.getCompletionItemList(listeners, context));
        return completionItems;
    }

    private List<LSCompletionItem> listenersInModule(BallerinaCompletionContext context, String modulePrefix) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
        Optional<ModuleSymbol> moduleSymbol = visibleSymbols.stream().filter(symbol -> symbol.kind() == SymbolKind.MODULE && ((String)symbol.getName().get()).equals(modulePrefix)).map(symbol -> (ModuleSymbol)symbol).findAny();
        if (moduleSymbol.isEmpty()) {
            return completionItems;
        }
        ModuleSymbol module = moduleSymbol.get();
        Stream classesAndTypeDefs = Stream.concat(module.classes().stream(), module.typeDefinitions().stream());
        List<Symbol> listeners = classesAndTypeDefs.filter(SymbolUtil::isListener).toList();
        completionItems.addAll(this.getCompletionItemList(listeners, context));
        return completionItems;
    }

    private Optional<ListenerDeclarationNode> listenerNode(BallerinaCompletionContext context) {
        NonTerminalNode node = context.getNodeAtCursor();
        while (node.kind() != SyntaxKind.LISTENER_DECLARATION && node.kind() != SyntaxKind.MODULE_PART) {
            node = node.parent();
        }
        if (node.kind() == SyntaxKind.LISTENER_DECLARATION) {
            return Optional.of((ListenerDeclarationNode)node);
        }
        return Optional.empty();
    }

    private boolean withinTypeDescContext(BallerinaCompletionContext context, ListenerDeclarationNode node) {
        int cursor = context.getCursorPositionInTree();
        Token varName = node.variableName();
        Token listenerKW = node.listenerKeyword();
        Optional tDesc = node.typeDescriptor();
        if (listenerKW.isMissing()) {
            return false;
        }
        return cursor >= listenerKW.textRange().startOffset() + 1 && (tDesc.isEmpty() && varName.isMissing() || tDesc.isEmpty() && !varName.isMissing() && cursor <= varName.textRange().endOffset() || tDesc.isPresent() && cursor <= ((TypeDescriptorNode)tDesc.get()).textRange().endOffset());
    }

    private boolean withinInitializerContext(BallerinaCompletionContext context, ListenerDeclarationNode node) {
        Token equalsToken = node.equalsToken();
        if (equalsToken.isMissing()) {
            return false;
        }
        Position cursorPos = context.getCursorPosition();
        LineRange lineRange = equalsToken.lineRange();
        return cursorPos.getLine() == lineRange.startLine().line() && cursorPos.getCharacter() > lineRange.startLine().offset() || cursorPos.getLine() > lineRange.startLine().line();
    }

    private Optional<ClassSymbol> getListenerTypeDesc(BallerinaCompletionContext context, ListenerDeclarationNode node) {
        Node typeDescriptor = node.typeDescriptor().orElse(null);
        Optional<ClassSymbol> typeSymbol = Optional.empty();
        List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
        if (typeDescriptor == null) {
            return typeSymbol;
        }
        if (typeDescriptor.kind() == SyntaxKind.QUALIFIED_NAME_REFERENCE) {
            QualifiedNameReferenceNode nameReferenceNode = (QualifiedNameReferenceNode)typeDescriptor;
            Optional<ModuleSymbol> moduleSymbol = ModuleUtil.searchModuleForAlias((PositionedOperationContext)context, QNameRefCompletionUtil.getAlias(nameReferenceNode));
            if (moduleSymbol.isEmpty()) {
                return Optional.empty();
            }
            ModuleSymbol module = moduleSymbol.get();
            Stream objsAndClasses = Stream.concat(module.classes().stream(), module.typeDefinitions().stream());
            typeSymbol = objsAndClasses.filter(type -> SymbolUtil.isListener(type) && Objects.equals(type.getName().orElse(null), nameReferenceNode.identifier().text())).map(symbol -> (ClassSymbol)symbol).findAny();
        } else if (typeDescriptor.kind() == SyntaxKind.SIMPLE_NAME_REFERENCE) {
            SimpleNameReferenceNode nameReferenceNode = (SimpleNameReferenceNode)typeDescriptor;
            typeSymbol = visibleSymbols.stream().filter(visibleSymbol -> SymbolUtil.isListener(visibleSymbol) && Objects.equals(visibleSymbol.getName().orElse(null), nameReferenceNode.name().text())).map(symbol -> (ClassSymbol)symbol).findAny();
        }
        return typeSymbol;
    }

    @Override
    protected List<LSCompletionItem> expressionCompletions(BallerinaCompletionContext context, ListenerDeclarationNode listenerNode) {
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            List<Symbol> ctxEntries = QNameRefCompletionUtil.getExpressionContextEntries(context, qNameRef);
            return this.getCompletionItemList(ctxEntries, context);
        }
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        List visibleSymbols = context.visibleSymbols(context.getCursorPosition());
        Optional<ClassSymbol> objectTypeDesc = this.getListenerTypeDesc(context, listenerNode);
        List<Symbol> filteredList = visibleSymbols.stream().filter(symbol -> symbol.kind() == SymbolKind.VARIABLE || symbol.kind() == SymbolKind.FUNCTION).toList();
        completionItems.addAll(this.getCompletionItemList(filteredList, context));
        completionItems.addAll(this.getModuleCompletionItems(context));
        objectTypeDesc.ifPresent(tDesc -> completionItems.add(this.getImplicitNewCItemForClass((ClassSymbol)tDesc, context)));
        List<Snippet> keywords = Arrays.asList(Snippet.KW_NEW, Snippet.KW_CHECK, Snippet.KW_CHECK_PANIC, Snippet.KW_TRAP);
        for (Snippet keyword : keywords) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, keyword.get()));
        }
        return completionItems;
    }

    private boolean isValidSymbolCompletionItem(LSCompletionItem lsCompletionItem) {
        return lsCompletionItem.getType() == LSCompletionItem.CompletionItemType.SYMBOL && ((SymbolCompletionItem)lsCompletionItem).getSymbol().isPresent();
    }

    private static enum ContextScope {
        TYPE_DESC,
        INITIALIZER,
        OTHER;

    }
}

