/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.syntax.tree.FieldMatchPatternNode;
import io.ballerina.compiler.syntax.tree.MappingMatchPatternNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.providers.context.MappingContextProvider;

public class MappingMatchPatternNodeContext
extends MappingContextProvider<MappingMatchPatternNode> {
    public MappingMatchPatternNodeContext() {
        super(MappingMatchPatternNode.class);
    }

    public List<LSCompletionItem> getCompletions(BallerinaCompletionContext context, MappingMatchPatternNode node) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        Optional<Node> evalNode = CommonUtil.getMappingContextEvalNode((Node)context.getNodeAtCursor());
        if (evalNode.isEmpty()) {
            return completionItems;
        }
        if (this.withinValueExpression(context, evalNode.get())) {
            completionItems.addAll(this.getCompletionsInValueExpressionContext(context));
        } else {
            completionItems.addAll(this.getFieldCompletionItems(context, node, evalNode.get()));
        }
        this.sort(context, node, completionItems);
        return completionItems;
    }

    @Override
    protected List<String> getFields(MappingMatchPatternNode node) {
        return node.fieldMatchPatterns().stream().filter(field -> !field.isMissing() && field.kind() == SyntaxKind.FIELD_MATCH_PATTERN && ((FieldMatchPatternNode)field).fieldNameNode().kind() == SyntaxKind.IDENTIFIER_TOKEN).map(field -> ((FieldMatchPatternNode)field).fieldNameNode().text()).toList();
    }

    @Override
    protected boolean withinValueExpression(BallerinaCompletionContext context, Node evalNodeAtCursor) {
        int colonStart;
        if (evalNodeAtCursor.kind() != SyntaxKind.FIELD_MATCH_PATTERN) {
            return false;
        }
        Token colon = ((FieldMatchPatternNode)evalNodeAtCursor).colonToken();
        int cursorPosInTree = context.getCursorPositionInTree();
        return cursorPosInTree > (colonStart = colon.textRange().startOffset());
    }
}

