/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.completions.providers.context;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.Document;
import io.ballerina.tools.text.LinePosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.ballerinalang.langserver.common.utils.CommonUtil;
import org.ballerinalang.langserver.commons.BallerinaCompletionContext;
import org.ballerinalang.langserver.commons.PositionedOperationContext;
import org.ballerinalang.langserver.commons.completion.LSCompletionItem;
import org.ballerinalang.langserver.completions.SnippetCompletionItem;
import org.ballerinalang.langserver.completions.providers.AbstractCompletionProvider;
import org.ballerinalang.langserver.completions.util.QNameRefCompletionUtil;
import org.ballerinalang.langserver.completions.util.Snippet;
import org.ballerinalang.langserver.completions.util.SortingUtil;

public abstract class NodeWithRHSInitializerProvider<T extends Node>
extends AbstractCompletionProvider<T> {
    public NodeWithRHSInitializerProvider(Class<T> attachmentPoint) {
        super(attachmentPoint);
    }

    @Override
    public void sort(BallerinaCompletionContext context, T node, List<LSCompletionItem> completionItems) {
        Optional contextType = Optional.empty();
        if (context.currentSemanticModel().isPresent() && context.currentDocument().isPresent()) {
            contextType = ((SemanticModel)context.currentSemanticModel().get()).expectedType((Document)context.currentDocument().get(), LinePosition.from((int)context.getCursorPosition().getLine(), (int)context.getCursorPosition().getCharacter()));
        }
        for (LSCompletionItem lsCItem : completionItems) {
            String sortText = contextType.isEmpty() ? SortingUtil.genSortText(SortingUtil.toRank(context, lsCItem)) : SortingUtil.genSortTextByAssignability(context, lsCItem, (TypeSymbol)contextType.get());
            lsCItem.getCompletionItem().setSortText(sortText);
        }
    }

    protected List<LSCompletionItem> initializerContextCompletions(BallerinaCompletionContext context, Node initializer) {
        NonTerminalNode nodeAtCursor = context.getNodeAtCursor();
        if (QNameRefCompletionUtil.onQualifiedNameIdentifier((PositionedOperationContext)context, (Node)nodeAtCursor)) {
            QualifiedNameReferenceNode qNameRef = (QualifiedNameReferenceNode)nodeAtCursor;
            Predicate<Symbol> filter = symbol -> symbol instanceof VariableSymbol || symbol.kind() == SymbolKind.FUNCTION || symbol.kind() == SymbolKind.TYPE_DEFINITION || symbol.kind() == SymbolKind.CLASS;
            List<Symbol> moduleContent = QNameRefCompletionUtil.getModuleContent((PositionedOperationContext)context, qNameRef, filter);
            return this.getCompletionItemList(moduleContent, context);
        }
        if (this.onSuggestionsAfterQualifiers(context, initializer)) {
            return this.getCompletionItemsOnQualifiers(initializer, context);
        }
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        completionItems.addAll(this.actionKWCompletions(context));
        completionItems.addAll(this.expressionCompletions(context));
        completionItems.addAll(this.getNewExprCompletionItems(context));
        if (this.withinTransactionStatementNode(context)) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.STMT_COMMIT.get()));
        }
        return completionItems;
    }

    @Override
    protected List<LSCompletionItem> getCompletionItemsOnQualifiers(Node node, BallerinaCompletionContext context) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>(super.getCompletionItemsOnQualifiers(node, context));
        if (node.kind() == SyntaxKind.MODULE_VAR_DECL) {
            return completionItems;
        }
        List<Token> qualifiers = CommonUtil.getQualifiersOfNode(context, node);
        if (qualifiers.isEmpty()) {
            return completionItems;
        }
        Token lastQualifier = qualifiers.get(qualifiers.size() - 1);
        if (lastQualifier.kind() == SyntaxKind.ISOLATED_KEYWORD) {
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.KW_FUNCTION.get()));
            completionItems.add((LSCompletionItem)new SnippetCompletionItem(context, Snippet.DEF_OBJECT_TYPE_DESC_SNIPPET.get()));
        }
        return completionItems;
    }

    protected List<LSCompletionItem> getNewExprCompletionItems(BallerinaCompletionContext context) {
        ArrayList<LSCompletionItem> completionItems = new ArrayList<LSCompletionItem>();
        Optional contextType = context.getContextType();
        if (contextType.isEmpty()) {
            return completionItems;
        }
        TypeSymbol typeSymbol = CommonUtil.getRawType((TypeSymbol)contextType.get());
        if (typeSymbol.typeKind() == TypeDescKind.UNION) {
            Optional<TypeSymbol> memberType = ((UnionTypeSymbol)typeSymbol).memberTypeDescriptors().stream().map(CommonUtil::getRawType).filter(type -> type.typeKind() == TypeDescKind.STREAM || type.kind() == SymbolKind.CLASS).findFirst();
            if (memberType.isEmpty()) {
                return completionItems;
            }
            typeSymbol = memberType.get();
        }
        if (typeSymbol.typeKind() == TypeDescKind.STREAM) {
            implicitNewCompletionItem = this.getImplicitNewCItemForStreamType(typeSymbol, context);
            completionItems.add(implicitNewCompletionItem);
        } else if (typeSymbol.kind() == SymbolKind.CLASS) {
            implicitNewCompletionItem = this.getImplicitNewCItemForClass((ClassSymbol)typeSymbol, context);
            completionItems.add(implicitNewCompletionItem);
        }
        return completionItems;
    }

    private boolean withinTransactionStatementNode(BallerinaCompletionContext context) {
        boolean withinTransaction = false;
        for (NonTerminalNode evalNode = context.getNodeAtCursor().parent(); evalNode != null; evalNode = evalNode.parent()) {
            if (evalNode.kind() != SyntaxKind.TRANSACTION_STATEMENT) continue;
            withinTransaction = true;
            break;
        }
        return withinTransaction;
    }
}

